/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.rotate;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.bdew.lib.rotate.BaseRotateableBlock;
import net.bdew.lib.rotate.IconType$;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import scala.Array$;
import scala.Enumeration;
import scala.reflect.ClassTag$;

public abstract class BaseRotateableBlock$class {
    public static Icon getIcon(BaseRotateableBlock $this, IBlockAccess world, int x, int y, int z, Enumeration.Value kind) {
        return $this.getIcon(world.func_72805_g(x, y, z), kind);
    }

    public static EnumSet getValidFacings(BaseRotateableBlock $this) {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public static ForgeDirection getDefaultFacing(BaseRotateableBlock $this) {
        return ForgeDirection.UP;
    }

    public static boolean rotateBlock(BaseRotateableBlock $this, World worldObj, int x, int y, int z, ForgeDirection axis) {
        if ($this.getValidFacings().contains(axis)) {
            $this.setFacing(worldObj, x, y, z, axis);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static Icon getIcon(BaseRotateableBlock $this, int side, int meta) {
        return $this.getIcon(meta, IconType$.MODULE$.fromSideAndDir(side, $this.getDefaultFacing()));
    }

    @SideOnly(value=Side.CLIENT)
    public static Icon getBlockTexture(BaseRotateableBlock $this, IBlockAccess world, int x, int y, int z, int side) {
        return $this.getIcon(world, x, y, z, IconType$.MODULE$.fromSideAndDir(side, $this.getFacing(world, x, y, z)));
    }

    public static ForgeDirection[] getValidRotations(BaseRotateableBlock $this, World worldObj, int x, int y, int z) {
        return (ForgeDirection[])$this.getValidFacings().toArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ForgeDirection.class)));
    }

    public static void onBlockPlacedBy(BaseRotateableBlock $this, World world, int x, int y, int z, EntityLivingBase ent, ItemStack stack) {
        EnumSet<ForgeDirection> validRotations = $this.getValidFacings();
        ForgeDirection dir = $this.getDefaultFacing();
        if (ent != null) {
            int yaw;
            int pitch = Math.round(ent.field_70125_A);
            int n = yaw = MathHelper.func_76128_c((double)((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            ForgeDirection forgeDirection = pitch >= 50 && validRotations.contains(ForgeDirection.UP) ? ForgeDirection.UP : (pitch <= -50 && validRotations.contains(ForgeDirection.DOWN) ? ForgeDirection.DOWN : (0 == n && validRotations.contains(ForgeDirection.NORTH) ? ForgeDirection.NORTH : (1 == n && validRotations.contains(ForgeDirection.EAST) ? ForgeDirection.EAST : (2 == n && validRotations.contains(ForgeDirection.SOUTH) ? ForgeDirection.SOUTH : (3 == n && validRotations.contains(ForgeDirection.WEST) ? ForgeDirection.WEST : dir)))));
            dir = forgeDirection;
        }
        $this.setFacing(world, x, y, z, dir);
        $this.net$bdew$lib$rotate$BaseRotateableBlock$$super$onBlockPlacedBy(world, x, y, z, ent, stack);
    }

    public static void $init$(BaseRotateableBlock $this) {
    }
}

