/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.bdew.lib.network.NBTMessageToMessageCodec;
import net.bdew.lib.network.NetChannelClientHandler;
import net.bdew.lib.network.NetChannelServerHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001-\u0011!BT3u\u0007\"\fgN\\3m\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0005\u00151\u0011a\u00017jE*\u0011q\u0001C\u0001\u0005E\u0012,wOC\u0001\n\u0003\rqW\r^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005!a.Y7f+\u0005)\u0002C\u0001\f\u001a\u001d\tiq#\u0003\u0002\u0019\u001d\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tAb\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015q\u0017-\\3!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011e\t\t\u0003E\u0001i\u0011A\u0001\u0005\u0006'y\u0001\r!\u0006\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003!\u0019\u0007.\u00198oK2\u001cX#A\u0014\u0011\t!jsfO\u0007\u0002S)\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#aB#ok6l\u0015\r\u001d\t\u0003aej\u0011!\r\u0006\u0003eM\n!B]3mCVt7\r[3s\u0015\t!T'A\u0002g[2T!AN\u001c\u0002\t5|Gm\u001d\u0006\u0002q\u0005\u00191\r]<\n\u0005i\n$\u0001B*jI\u0016\u0004\"\u0001\u0010!\u000e\u0003uR!a\u0001 \u000b\u0005}\u001a\u0014AB2p[6|g.\u0003\u0002B{\t\u0011b)\u0014'F[\n,G\rZ3e\u0007\"\fgN\\3m\u0011\u0019\u0019\u0005\u0001)A\u0005O\u0005I1\r[1o]\u0016d7\u000f\t\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u00039\u0019XM\u001d<fe\"\u000bg\u000e\u001a7feN,\u0012a\u0012\t\u0005\u00116+r*D\u0001J\u0015\tQ5*A\u0005j[6,H/\u00192mK*\u0011AJD\u0001\u000bG>dG.Z2uS>t\u0017B\u0001(J\u0005\ri\u0015\r\u001d\t\u0006\u001bA\u0013&LY\u0005\u0003#:\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016a\u00018ci*\u0011q\u000bC\u0001\n[&tWm\u0019:bMRL!!\u0017+\u0003\u001d9\u0013E\u000bV1h\u0007>l\u0007o\\;oIB\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0007a2\f\u00170\u001a:\u000b\u0005}3\u0016AB3oi&$\u00180\u0003\u0002b9\nqQI\u001c;jif\u0004F.Y=fe6\u0003\u0006CA\u0007d\u0013\t!gB\u0001\u0003V]&$\bb\u00024\u0001\u0001\u0004%\taZ\u0001\u0013g\u0016\u0014h/\u001a:IC:$G.\u001a:t?\u0012*\u0017\u000f\u0006\u0002cQ\"9\u0011.ZA\u0001\u0002\u00049\u0015a\u0001=%c!11\u000e\u0001Q!\n\u001d\u000bqb]3sm\u0016\u0014\b*\u00198eY\u0016\u00148\u000f\t\u0005\b[\u0002\u0001\r\u0011\"\u0001o\u00039\u0019G.[3oi\"\u000bg\u000e\u001a7feN,\u0012a\u001c\t\u0005\u00116+\u0002\u000f\u0005\u0003\u000ecJ\u0013\u0017B\u0001:\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0004u\u0001\u0001\u0007I\u0011A;\u0002%\rd\u0017.\u001a8u\u0011\u0006tG\r\\3sg~#S-\u001d\u000b\u0003EZDq![:\u0002\u0002\u0003\u0007q\u000e\u0003\u0004y\u0001\u0001\u0006Ka\\\u0001\u0010G2LWM\u001c;IC:$G.\u001a:tA!)!\u0010\u0001C\u0001w\u0006\u0001\"/Z4TKJ4XM\u001d%b]\u0012dWM\u001d\u000b\u0004Ert\b\"B?z\u0001\u0004)\u0012AA5e\u0011\u0015y\u0018\u00101\u0001P\u0003!\u0019\u0017\r\u001c7bE2,\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0011e\u0016<7\t\\5f]RD\u0015M\u001c3mKJ$RAYA\u0004\u0003\u0013Aa!`A\u0001\u0001\u0004)\u0002BB@\u0002\u0002\u0001\u0007\u0001\u000fC\u0004\u0002\u000e\u0001!\t!a\u0004\u0002\u0015\u0005$G\rS1oI2,'\u000fF\u0003c\u0003#\t)\u0002C\u0004\u0002\u0014\u0005-\u0001\u0019A\u0018\u0002\tMLG-\u001a\u0005\t\u0003/\tY\u00011\u0001\u0002\u001a\u00059\u0001.\u00198eY\u0016\u0014\b\u0003BA\u000e\u0003Si!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\bG\"\fgN\\3m\u0015\u0011\t\u0019#!\n\u0002\u000b9,G\u000f^=\u000b\u0005\u0005\u001d\u0012AA5p\u0013\u0011\tY#!\b\u0003\u001d\rC\u0017M\u001c8fY\"\u000bg\u000e\u001a7fe\"9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012!C:f]\u0012$v.\u00117m)\r\u0011\u00171\u0007\u0005\b\u0003k\ti\u00031\u0001S\u0003\u001diWm]:bO\u0016Dq!!\u000f\u0001\t\u0003\tY$\u0001\u0004tK:$Gk\u001c\u000b\u0006E\u0006u\u0012q\b\u0005\b\u0003k\t9\u00041\u0001S\u0011\u0019i\u0016q\u0007a\u00015\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013aD:f]\u0012$v.\u00117m\u0003J|WO\u001c3\u0015\u000b\t\f9%!\u0013\t\u000f\u0005U\u0012\u0011\ta\u0001%\"A\u00111JA!\u0001\u0004\ti%A\u0003q_&tG\u000f\u0005\u0003\u0002P\u0005Ucb\u0001\u001f\u0002R%\u0019\u00111K\u001f\u0002\u001f9+Go^8sWJ+w-[:uefLA!a\u0016\u0002Z\tYA+\u0019:hKR\u0004v.\u001b8u\u0015\r\t\u0019&\u0010\u0005\b\u0003;\u0002A\u0011AA0\u0003=\u0019XM\u001c3U_\u0012KW.\u001a8tS>tG#\u00022\u0002b\u0005\r\u0004bBA\u001b\u00037\u0002\rA\u0015\u0005\t\u0003K\nY\u00061\u0001\u0002h\u0005YA-[7f]NLwN\\%e!\ri\u0011\u0011N\u0005\u0004\u0003Wr!aA%oi\"9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014\u0001D:f]\u0012$vnU3sm\u0016\u0014Hc\u00012\u0002t!9\u0011QGA7\u0001\u0004\u0011\u0006")
public class NetChannel {
    private final String name;
    private final EnumMap<Side, FMLEmbeddedChannel> channels;
    private Map<String, Function2<NBTTagCompound, EntityPlayerMP, BoxedUnit>> serverHandlers;
    private Map<String, Function1<NBTTagCompound, BoxedUnit>> clientHandlers;

    public String name() {
        return this.name;
    }

    public EnumMap<Side, FMLEmbeddedChannel> channels() {
        return this.channels;
    }

    public Map<String, Function2<NBTTagCompound, EntityPlayerMP, BoxedUnit>> serverHandlers() {
        return this.serverHandlers;
    }

    public void serverHandlers_$eq(Map<String, Function2<NBTTagCompound, EntityPlayerMP, BoxedUnit>> x$1) {
        this.serverHandlers = x$1;
    }

    public Map<String, Function1<NBTTagCompound, BoxedUnit>> clientHandlers() {
        return this.clientHandlers;
    }

    public void clientHandlers_$eq(Map<String, Function1<NBTTagCompound, BoxedUnit>> x$1) {
        this.clientHandlers = x$1;
    }

    public void regServerHandler(String id, Function2<NBTTagCompound, EntityPlayerMP, BoxedUnit> callable) {
        if (this.serverHandlers().contains((Object)id)) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Command name already in use: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        this.serverHandlers_$eq((Map<String, Function2<NBTTagCompound, EntityPlayerMP, BoxedUnit>>)this.serverHandlers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), callable)));
    }

    public void regClientHandler(String id, Function1<NBTTagCompound, BoxedUnit> callable) {
        if (this.clientHandlers().contains((Object)id)) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Command name already in use: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
        }
        this.clientHandlers_$eq((Map<String, Function1<NBTTagCompound, BoxedUnit>>)this.clientHandlers().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)id), callable)));
    }

    public void addHandler(Side side, ChannelHandler handler) {
        FMLEmbeddedChannel ch = this.channels().get(side);
        String name = ch.findChannelHandlerNameForType(NBTMessageToMessageCodec.class);
        ch.pipeline().addAfter(name, Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)side), "Handler"), handler);
    }

    public void sendToAll(NBTTagCompound message) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(NBTTagCompound message, EntityPlayerMP player) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(NBTTagCompound message, NetworkRegistry.TargetPoint point) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(NBTTagCompound message, int dimensionId) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(dimensionId));
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(NBTTagCompound message) {
        ((DefaultAttributeMap)this.channels().get(Side.CLIENT)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        ((AbstractChannel)this.channels().get(Side.CLIENT)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public NetChannel(String name) {
        this.name = name;
        this.channels = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{new NBTMessageToMessageCodec()});
        this.serverHandlers = Predef$.MODULE$.Map().empty();
        this.clientHandlers = Predef$.MODULE$.Map().empty();
        this.addHandler(Side.SERVER, (ChannelHandler)new NetChannelServerHandler(this));
        this.addHandler(Side.CLIENT, (ChannelHandler)new NetChannelClientHandler(this));
    }
}

