/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.bdew.lib.BdLib$;
import net.bdew.lib.Misc$;
import net.bdew.lib.network.Message;
import net.bdew.lib.network.NetChannelClientHandler;
import net.bdew.lib.network.NetChannelServerHandler;
import net.bdew.lib.network.SerializedMessageCodec;
import net.minecraft.entity.player.EntityPlayerMP;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001-\u0011!BT3u\u0007\"\fgN\\3m\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0005\u00151\u0011a\u00017jE*\u0011q\u0001C\u0001\u0005E\u0012,wOC\u0001\n\u0003\rqW\r^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005!a.Y7f+\u0005)\u0002C\u0001\f\u001a\u001d\tiq#\u0003\u0002\u0019\u001d\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tAb\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015q\u0017-\\3!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011e\t\t\u0003E\u0001i\u0011A\u0001\u0005\u0006'y\u0001\r!\u0006\u0005\bK\u0001\u0001\r\u0011\"\u0001'\u0003!\u0019\u0007.\u00198oK2\u001cX#A\u0014\u0011\t!jsfO\u0007\u0002S)\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#aB#ok6l\u0015\r\u001d\t\u0003aej\u0011!\r\u0006\u0003eM\n!B]3mCVt7\r[3s\u0015\t!T'A\u0002g[2T!AN\u001c\u0002\t5|Gm\u001d\u0006\u0002q\u0005\u00191\r]<\n\u0005i\n$\u0001B*jI\u0016\u0004\"\u0001\u0010!\u000e\u0003uR!a\u0001 \u000b\u0005}\u001a\u0014AB2p[6|g.\u0003\u0002B{\t\u0011b)\u0014'F[\n,G\rZ3e\u0007\"\fgN\\3m\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000bAb\u00195b]:,Gn]0%KF$\"!\u0012%\u0011\u000551\u0015BA$\u000f\u0005\u0011)f.\u001b;\t\u000f%\u0013\u0015\u0011!a\u0001O\u0005\u0019\u0001\u0010J\u0019\t\r-\u0003\u0001\u0015)\u0003(\u0003%\u0019\u0007.\u00198oK2\u001c\b\u0005C\u0003N\u0001\u0011\u0005a*\u0001\u0003j]&$H#A#\t\u000fA\u0003\u0001\u0019!C\u0001#\u0006Y1\r\\5f]R\u001c\u0005.Y5o+\u0005\u0011\u0006\u0003B\u0007T+\u0016K!\u0001\u0016\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"A\t,\n\u0005]\u0013!aB'fgN\fw-\u001a\u0005\b3\u0002\u0001\r\u0011\"\u0001[\u0003=\u0019G.[3oi\u000eC\u0017-\u001b8`I\u0015\fHCA#\\\u0011\u001dI\u0005,!AA\u0002ICa!\u0018\u0001!B\u0013\u0011\u0016\u0001D2mS\u0016tGo\u00115bS:\u0004\u0003bB0\u0001\u0001\u0004%\t\u0001Y\u0001\fg\u0016\u0014h/\u001a:DQ\u0006Lg.F\u0001b!\u0011i1KY#\u0011\t5\u0019W+Z\u0005\u0003I:\u0011a\u0001V;qY\u0016\u0014\u0004C\u00014n\u001b\u00059'B\u00015j\u0003\u0019\u0001H.Y=fe*\u0011!n[\u0001\u0007K:$\u0018\u000e^=\u000b\u00051D\u0011!C7j]\u0016\u001c'/\u00194u\u0013\tqwM\u0001\bF]RLG/\u001f)mCf,'/\u0014)\t\u000fA\u0004\u0001\u0019!C\u0001c\u0006y1/\u001a:wKJ\u001c\u0005.Y5o?\u0012*\u0017\u000f\u0006\u0002Fe\"9\u0011j\\A\u0001\u0002\u0004\t\u0007B\u0002;\u0001A\u0003&\u0011-\u0001\u0007tKJ4XM]\"iC&t\u0007\u0005C\u0003w\u0001\u0011\u0005q/\u0001\tsK\u001e\u001cVM\u001d<fe\"\u000bg\u000e\u001a7feR\u0011Q\t\u001f\u0005\u0006sV\u0004\r!Y\u0001\u0002M\")1\u0010\u0001C\u0001y\u0006\u0001\"/Z4DY&,g\u000e\u001e%b]\u0012dWM\u001d\u000b\u0003\u000bvDQ!\u001f>A\u0002ICaa \u0001\u0005\n\u0005\u0005\u0011AC1eI\"\u000bg\u000e\u001a7feR)Q)a\u0001\u0002\b!1\u0011Q\u0001@A\u0002=\nAa]5eK\"9\u0011\u0011\u0002@A\u0002\u0005-\u0011a\u00025b]\u0012dWM\u001d\t\u0005\u0003\u001b\tY\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u001d\u0019\u0007.\u00198oK2TA!!\u0006\u0002\u0018\u0005)a.\u001a;us*\u0011\u0011\u0011D\u0001\u0003S>LA!!\b\u0002\u0010\tq1\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\bbBA\u0011\u0001\u0011\u0005\u00111E\u0001\ng\u0016tG\rV8BY2$2!RA\u0013\u0011\u001d\t9#a\bA\u0002U\u000bq!\\3tg\u0006<W\rC\u0004\u0002,\u0001!\t!!\f\u0002\rM,g\u000e\u001a+p)\u0015)\u0015qFA\u0019\u0011\u001d\t9#!\u000bA\u0002UCa\u0001[A\u0015\u0001\u0004)\u0007bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u0010g\u0016tG\rV8BY2\f%o\\;oIR)Q)!\u000f\u0002<!9\u0011qEA\u001a\u0001\u0004)\u0006\u0002CA\u001f\u0003g\u0001\r!a\u0010\u0002\u000bA|\u0017N\u001c;\u0011\t\u0005\u0005\u0013q\t\b\u0004y\u0005\r\u0013bAA#{\u0005ya*\u001a;x_J\\'+Z4jgR\u0014\u00180\u0003\u0003\u0002J\u0005-#a\u0003+be\u001e,G\u000fU8j]RT1!!\u0012>\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\nqb]3oIR{G)[7f]NLwN\u001c\u000b\u0006\u000b\u0006M\u0013Q\u000b\u0005\b\u0003O\ti\u00051\u0001V\u0011!\t9&!\u0014A\u0002\u0005e\u0013a\u00033j[\u0016t7/[8o\u0013\u0012\u00042!DA.\u0013\r\tiF\u0004\u0002\u0004\u0013:$\bbBA1\u0001\u0011\u0005\u00111M\u0001\rg\u0016tG\rV8TKJ4XM\u001d\u000b\u0004\u000b\u0006\u0015\u0004bBA\u0014\u0003?\u0002\r!\u0016")
public class NetChannel {
    private final String name;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private PartialFunction<Message, BoxedUnit> clientChain;
    private PartialFunction<Tuple2<Message, EntityPlayerMP>, BoxedUnit> serverChain;

    public String name() {
        return this.name;
    }

    public EnumMap<Side, FMLEmbeddedChannel> channels() {
        return this.channels;
    }

    public void channels_$eq(EnumMap<Side, FMLEmbeddedChannel> x$1) {
        this.channels = x$1;
    }

    public void init() {
        this.channels_$eq(NetworkRegistry.INSTANCE.newChannel(this.name(), new ChannelHandler[]{new SerializedMessageCodec()}));
        BdLib$.MODULE$.logInfo("Initialized network channel '%s' for mod '%s'", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), Misc$.MODULE$.getActiveModId()}));
        this.addHandler(Side.SERVER, (ChannelHandler)new NetChannelServerHandler(this));
        this.addHandler(Side.CLIENT, (ChannelHandler)new NetChannelClientHandler(this));
    }

    public PartialFunction<Message, BoxedUnit> clientChain() {
        return this.clientChain;
    }

    public void clientChain_$eq(PartialFunction<Message, BoxedUnit> x$1) {
        this.clientChain = x$1;
    }

    public PartialFunction<Tuple2<Message, EntityPlayerMP>, BoxedUnit> serverChain() {
        return this.serverChain;
    }

    public void serverChain_$eq(PartialFunction<Tuple2<Message, EntityPlayerMP>, BoxedUnit> x$1) {
        this.serverChain = x$1;
    }

    public void regServerHandler(PartialFunction<Tuple2<Message, EntityPlayerMP>, BoxedUnit> f) {
        this.serverChain_$eq((PartialFunction<Tuple2<Message, EntityPlayerMP>, BoxedUnit>)this.serverChain().orElse(f));
    }

    public void regClientHandler(PartialFunction<Message, BoxedUnit> f) {
        this.clientChain_$eq((PartialFunction<Message, BoxedUnit>)this.clientChain().orElse(f));
    }

    private void addHandler(Side side, ChannelHandler handler) {
        FMLEmbeddedChannel ch = this.channels().get(side);
        String name = ch.findChannelHandlerNameForType(SerializedMessageCodec.class);
        ch.pipeline().addAfter(name, Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)side), "Handler"), handler);
    }

    public void sendToAll(Message message) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(Message message, EntityPlayerMP player) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(Message message, NetworkRegistry.TargetPoint point) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(Message message, int dimensionId) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(dimensionId));
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(Message message) {
        ((DefaultAttributeMap)this.channels().get(Side.CLIENT)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        ((AbstractChannel)this.channels().get(Side.CLIENT)).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public NetChannel(String name) {
        this.name = name;
        this.channels = null;
        this.clientChain = PartialFunction$.MODULE$.empty();
        this.serverChain = PartialFunction$.MODULE$.empty();
    }
}

