/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.bdew.lib.BdLib$;
import net.bdew.lib.Misc$;
import net.bdew.lib.network.BaseMessage;
import net.bdew.lib.network.NetChannel$ClientHandler$;
import net.bdew.lib.network.NetChannel$ServerHandler$;
import net.bdew.lib.network.SerializedMessageCodec;
import net.minecraft.entity.player.EntityPlayerMP;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001-\u0011!BT3u\u0007\"\fgN\\3m\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0005\u00151\u0011a\u00017jE*\u0011q\u0001C\u0001\u0005E\u0012,wOC\u0001\n\u0003\rqW\r^\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011)\u0019!C\u0001)\u0005!a.Y7f+\u0005)\u0002C\u0001\f\u001a\u001d\tiq#\u0003\u0002\u0019\u001d\u00051\u0001K]3eK\u001aL!AG\u000e\u0003\rM#(/\u001b8h\u0015\tAb\u0002\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u0016\u0003\u0015q\u0017-\\3!\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\u0011\u0011e\t\t\u0003E\u0001i\u0011A\u0001\u0005\u0006'y\u0001\r!\u0006\u0005\bK\u0001\u0001\r\u0011\"\u0001'\u0003!\u0019\u0007.\u00198oK2\u001cX#A\u0014\u0011\t!jsfO\u0007\u0002S)\u0011!fK\u0001\u0005kRLGNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059J#aB#ok6l\u0015\r\u001d\t\u0003aej\u0011!\r\u0006\u0003eM\n!B]3mCVt7\r[3s\u0015\t!T'A\u0002g[2T!AN\u001c\u0002\t5|Gm\u001d\u0006\u0002q\u0005\u00191\r]<\n\u0005i\n$\u0001B*jI\u0016\u0004\"\u0001\u0010!\u000e\u0003uR!a\u0001 \u000b\u0005}\u001a\u0014AB2p[6|g.\u0003\u0002B{\t\u0011b)\u0014'F[\n,G\rZ3e\u0007\"\fgN\\3m\u0011\u001d\u0019\u0005\u00011A\u0005\u0002\u0011\u000bAb\u00195b]:,Gn]0%KF$\"!\u0012%\u0011\u000551\u0015BA$\u000f\u0005\u0011)f.\u001b;\t\u000f%\u0013\u0015\u0011!a\u0001O\u0005\u0019\u0001\u0010J\u0019\t\r-\u0003\u0001\u0015)\u0003(\u0003%\u0019\u0007.\u00198oK2\u001c\b%\u0002\u0003N\u0001\u0001q%aB'fgN\fw-\u001a\t\u0004E=\u000b\u0016B\u0001)\u0003\u0005-\u0011\u0015m]3NKN\u001c\u0018mZ3\u000e\u0003\u00019Qa\u0015\u0001\t\u0002Q\u000bQbU3sm\u0016\u0014\b*\u00198eY\u0016\u0014\bCA)V\r\u00151\u0006\u0001#\u0001X\u00055\u0019VM\u001d<fe\"\u000bg\u000e\u001a7feN\u0011Q\u000b\u0017\t\u00043\u0002\u0014W\"\u0001.\u000b\u0005mc\u0016aB2iC:tW\r\u001c\u0006\u0003;z\u000bQA\\3uifT\u0011aX\u0001\u0003S>L!!\u0019.\u00037MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s!\t\tF\nC\u0003 +\u0012\u0005A\rF\u0001U\u0011\u00151W\u000b\"\u0001h\u00031\u0019\u0007.\u00198oK2\u0014V-\u001931)\r)\u0005.\u001c\u0005\u0006S\u0016\u0004\rA[\u0001\u0004GRD\bCA-l\u0013\ta'LA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000b9,\u0007\u0019\u00012\u0002\u00075\u001cxmB\u0003q\u0001!\u0005\u0011/A\u0007DY&,g\u000e\u001e%b]\u0012dWM\u001d\t\u0003#J4Qa\u001d\u0001\t\u0002Q\u0014Qb\u00117jK:$\b*\u00198eY\u0016\u00148C\u0001:Y\u0011\u0015y\"\u000f\"\u0001w)\u0005\t\b\"\u00024s\t\u0003AHcA#zu\")\u0011n\u001ea\u0001U\")an\u001ea\u0001E\")A\u0010\u0001C\u0001{\u0006!\u0011N\\5u)\u0005)\u0005\u0002C@\u0001\u0001\u0004%\t!!\u0001\u0002\u0017\rd\u0017.\u001a8u\u0007\"\f\u0017N\\\u000b\u0003\u0003\u0007\u0001R!DA\u0003E\u0016K1!a\u0002\u000f\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\"CA\u0006\u0001\u0001\u0007I\u0011AA\u0007\u0003=\u0019G.[3oi\u000eC\u0017-\u001b8`I\u0015\fHcA#\u0002\u0010!I\u0011*!\u0003\u0002\u0002\u0003\u0007\u00111\u0001\u0005\t\u0003'\u0001\u0001\u0015)\u0003\u0002\u0004\u0005a1\r\\5f]R\u001c\u0005.Y5oA!I\u0011q\u0003\u0001A\u0002\u0013\u0005\u0011\u0011D\u0001\fg\u0016\u0014h/\u001a:DQ\u0006Lg.\u0006\u0002\u0002\u001cA1Q\"!\u0002\u0002\u001e\u0015\u0003b!DA\u0010E\u0006\r\u0012bAA\u0011\u001d\t1A+\u001e9mKJ\u0002B!!\n\u000245\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0004qY\u0006LXM\u001d\u0006\u0005\u0003[\ty#\u0001\u0004f]RLG/\u001f\u0006\u0004\u0003cA\u0011!C7j]\u0016\u001c'/\u00194u\u0013\u0011\t)$a\n\u0003\u001d\u0015sG/\u001b;z!2\f\u00170\u001a:N!\"I\u0011\u0011\b\u0001A\u0002\u0013\u0005\u00111H\u0001\u0010g\u0016\u0014h/\u001a:DQ\u0006Lgn\u0018\u0013fcR\u0019Q)!\u0010\t\u0013%\u000b9$!AA\u0002\u0005m\u0001\u0002CA!\u0001\u0001\u0006K!a\u0007\u0002\u0019M,'O^3s\u0007\"\f\u0017N\u001c\u0011\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005\u0001\"/Z4TKJ4XM\u001d%b]\u0012dWM\u001d\u000b\u0004\u000b\u0006%\u0003\u0002CA&\u0003\u0007\u0002\r!a\u0007\u0002\u0003\u0019Dq!a\u0014\u0001\t\u0003\t\t&\u0001\tsK\u001e\u001cE.[3oi\"\u000bg\u000e\u001a7feR\u0019Q)a\u0015\t\u0011\u0005-\u0013Q\na\u0001\u0003\u0007Aq!a\u0016\u0001\t\u0013\tI&\u0001\u0006bI\u0012D\u0015M\u001c3mKJ$R!RA.\u0003?Bq!!\u0018\u0002V\u0001\u0007q&\u0001\u0003tS\u0012,\u0007\u0002CA1\u0003+\u0002\r!a\u0019\u0002\u000f!\fg\u000e\u001a7feB\u0019\u0011,!\u001a\n\u0007\u0005\u001d$L\u0001\bDQ\u0006tg.\u001a7IC:$G.\u001a:\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u0005I1/\u001a8e)>\fE\u000e\u001c\u000b\u0004\u000b\u0006=\u0004bBA9\u0003S\u0002\rAY\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\t)\b\u0001C\u0001\u0003o\naa]3oIR{G#B#\u0002z\u0005m\u0004bBA9\u0003g\u0002\rA\u0019\u0005\t\u0003S\t\u0019\b1\u0001\u0002$!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015aD:f]\u0012$v.\u00117m\u0003J|WO\u001c3\u0015\u000b\u0015\u000b\u0019)!\"\t\u000f\u0005E\u0014Q\u0010a\u0001E\"A\u0011qQA?\u0001\u0004\tI)A\u0003q_&tG\u000f\u0005\u0003\u0002\f\u0006Eeb\u0001\u001f\u0002\u000e&\u0019\u0011qR\u001f\u0002\u001f9+Go^8sWJ+w-[:uefLA!a%\u0002\u0016\nYA+\u0019:hKR\u0004v.\u001b8u\u0015\r\ty)\u0010\u0005\b\u00033\u0003A\u0011AAN\u0003=\u0019XM\u001c3U_\u0012KW.\u001a8tS>tG#B#\u0002\u001e\u0006}\u0005bBA9\u0003/\u0003\rA\u0019\u0005\t\u0003C\u000b9\n1\u0001\u0002$\u0006YA-[7f]NLwN\\%e!\ri\u0011QU\u0005\u0004\u0003Os!aA%oi\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0016\u0001D:f]\u0012$vnU3sm\u0016\u0014HcA#\u00020\"9\u0011\u0011OAU\u0001\u0004\u0011\u0007")
public class NetChannel {
    private final String name;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private PartialFunction<BaseMessage<NetChannel>, BoxedUnit> clientChain;
    private PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> serverChain;
    private volatile NetChannel$ServerHandler$ ServerHandler$module;
    private volatile NetChannel$ClientHandler$ ClientHandler$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetChannel$ServerHandler$ ServerHandler$lzycompute() {
        NetChannel netChannel = this;
        synchronized (netChannel) {
            if (this.ServerHandler$module != null) return this.ServerHandler$module;
            this.ServerHandler$module = new NetChannel$ServerHandler$(this);
            return this.ServerHandler$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NetChannel$ClientHandler$ ClientHandler$lzycompute() {
        NetChannel netChannel = this;
        synchronized (netChannel) {
            if (this.ClientHandler$module != null) return this.ClientHandler$module;
            this.ClientHandler$module = new NetChannel$ClientHandler$(this);
            return this.ClientHandler$module;
        }
    }

    public String name() {
        return this.name;
    }

    public EnumMap<Side, FMLEmbeddedChannel> channels() {
        return this.channels;
    }

    public void channels_$eq(EnumMap<Side, FMLEmbeddedChannel> x$1) {
        this.channels = x$1;
    }

    public NetChannel$ServerHandler$ ServerHandler() {
        return this.ServerHandler$module == null ? this.ServerHandler$lzycompute() : this.ServerHandler$module;
    }

    public NetChannel$ClientHandler$ ClientHandler() {
        return this.ClientHandler$module == null ? this.ClientHandler$lzycompute() : this.ClientHandler$module;
    }

    public void init() {
        if (this.channels() == null) {
            this.channels_$eq(NetworkRegistry.INSTANCE.newChannel(this.name(), new ChannelHandler[]{new SerializedMessageCodec()}));
            BdLib$.MODULE$.logInfo("Initialized network channel '%s' for mod '%s'", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name(), Misc$.MODULE$.getActiveModId()}));
            this.addHandler(Side.SERVER, (ChannelHandler)this.ServerHandler());
            this.addHandler(Side.CLIENT, (ChannelHandler)this.ClientHandler());
            return;
        }
        throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("Attempted to initialize a channel twice (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})));
    }

    public PartialFunction<BaseMessage<NetChannel>, BoxedUnit> clientChain() {
        return this.clientChain;
    }

    public void clientChain_$eq(PartialFunction<BaseMessage<NetChannel>, BoxedUnit> x$1) {
        this.clientChain = x$1;
    }

    public PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> serverChain() {
        return this.serverChain;
    }

    public void serverChain_$eq(PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> x$1) {
        this.serverChain = x$1;
    }

    public void regServerHandler(PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit> f) {
        this.serverChain_$eq((PartialFunction<Tuple2<BaseMessage<NetChannel>, EntityPlayerMP>, BoxedUnit>)this.serverChain().orElse(f));
    }

    public void regClientHandler(PartialFunction<BaseMessage<NetChannel>, BoxedUnit> f) {
        this.clientChain_$eq((PartialFunction<BaseMessage<NetChannel>, BoxedUnit>)this.clientChain().orElse(f));
    }

    private void addHandler(Side side, ChannelHandler handler) {
        FMLEmbeddedChannel ch = this.channels().get(side);
        String name = ch.findChannelHandlerNameForType(SerializedMessageCodec.class);
        ch.pipeline().addAfter(name, Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)side), "Handler"), handler);
    }

    public void sendToAll(BaseMessage<NetChannel> message) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendTo(BaseMessage<NetChannel> message, EntityPlayerMP player) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToAllAround(BaseMessage<NetChannel> message, NetworkRegistry.TargetPoint point) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToDimension(BaseMessage<NetChannel> message, int dimensionId) {
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        ((DefaultAttributeMap)this.channels().get(Side.SERVER)).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new Integer(dimensionId));
        ((AbstractChannel)this.channels().get(Side.SERVER)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToServer(BaseMessage<NetChannel> message) {
        ((DefaultAttributeMap)this.channels().get(Side.CLIENT)).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        ((AbstractChannel)this.channels().get(Side.CLIENT)).writeAndFlush(message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public NetChannel(String name) {
        this.name = name;
        this.channels = null;
        this.clientChain = PartialFunction$.MODULE$.empty();
        this.serverChain = PartialFunction$.MODULE$.empty();
    }
}

