/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.gendustry.misc;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Collection;
import net.bdew.gendustry.Gendustry$;
import net.bdew.gendustry.forestry.GeneSampleInfo;
import net.bdew.gendustry.misc.GeneticsCache$;
import net.bdew.gendustry.misc.GeneticsCache$SampleOrdering$;
import net.bdew.lib.Misc$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.SortedSet$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.SortedSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GeneticsCache$ {
    public static final GeneticsCache$ MODULE$;
    private final Map<IAlleleSpecies, scala.collection.SortedSet<IMutation>> speciesResultMutations;
    private final Map<IAlleleSpecies, scala.collection.SortedSet<IMutation>> speciesUsedMutations;
    private final Map<GeneSampleInfo, scala.collection.SortedSet<IAlleleSpecies>> speciesChromosomes;
    private SortedSet<GeneSampleInfo> geneSamples;

    static {
        new GeneticsCache$();
    }

    public Map<IAlleleSpecies, scala.collection.SortedSet<IMutation>> speciesResultMutations() {
        return this.speciesResultMutations;
    }

    public Map<IAlleleSpecies, scala.collection.SortedSet<IMutation>> speciesUsedMutations() {
        return this.speciesUsedMutations;
    }

    public Map<GeneSampleInfo, scala.collection.SortedSet<IAlleleSpecies>> speciesChromosomes() {
        return this.speciesChromosomes;
    }

    public SortedSet<GeneSampleInfo> geneSamples() {
        return this.geneSamples;
    }

    public void geneSamples_$eq(SortedSet<GeneSampleInfo> x$1) {
        this.geneSamples = x$1;
    }

    public void load() {
        Gendustry$.MODULE$.logInfo("Preparing genetics cache ...", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        JavaConversions$.MODULE$.mapAsScalaMap(AlleleManager.alleleRegistry.getSpeciesRoot()).withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<String, ISpeciesRoot> check$ifrefutable$1) {
                Tuple2<String, ISpeciesRoot> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(){

            public final void apply(Tuple2<String, ISpeciesRoot> x$1) {
                Tuple2<String, ISpeciesRoot> tuple2 = x$1;
                if (tuple2 != null) {
                    ISpeciesRoot root = (ISpeciesRoot)tuple2._2();
                    JavaConversions$.MODULE$.collectionAsScalaIterable(root.getMutations(false)).foreach((Function1)new Serializable(this){

                        public final void apply(IMutation mutation) {
                            IAlleleSpecies iAlleleSpecies = (IAlleleSpecies)mutation.getTemplate()[0];
                            GeneticsCache$.MODULE$.speciesResultMutations().update((Object)iAlleleSpecies, (Object)((SetLike)GeneticsCache$.MODULE$.speciesResultMutations().apply((Object)iAlleleSpecies)).$plus((Object)mutation));
                            IAlleleSpecies iAlleleSpecies2 = (IAlleleSpecies)mutation.getAllele0();
                            GeneticsCache$.MODULE$.speciesUsedMutations().update((Object)iAlleleSpecies2, (Object)((SetLike)GeneticsCache$.MODULE$.speciesUsedMutations().apply((Object)iAlleleSpecies2)).$plus((Object)mutation));
                            IAlleleSpecies iAlleleSpecies3 = (IAlleleSpecies)mutation.getAllele1();
                            GeneticsCache$.MODULE$.speciesUsedMutations().update((Object)iAlleleSpecies3, (Object)((SetLike)GeneticsCache$.MODULE$.speciesUsedMutations().apply((Object)iAlleleSpecies3)).$plus((Object)mutation));
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Gendustry$.MODULE$.logInfo("Mutations with multiple results from a single combination:", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        Gendustry$.MODULE$.logInfo("(This is not an error, no need to report it to anybody)", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.speciesUsedMutations().foreach((Function1)new Serializable(){

            public final void apply(Tuple2<IAlleleSpecies, scala.collection.SortedSet<IMutation>> x0$1) {
                Tuple2<IAlleleSpecies, scala.collection.SortedSet<IMutation>> tuple2 = x0$1;
                if (tuple2 != null) {
                    IAlleleSpecies sp1 = (IAlleleSpecies)tuple2._1();
                    scala.collection.SortedSet mutations = (scala.collection.SortedSet)tuple2._2();
                    List pairs = (List)mutations.toList().map((Function1)new Serializable(this, sp1){
                        private final IAlleleSpecies sp1$1;

                        public final Tuple2<IAllele, IMutation> apply(IMutation mutation) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mutation.getPartner((IAllele)this.sp1$1)), (Object)mutation);
                        }
                        {
                            this.sp1$1 = sp1$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    ((List)((TraversableLike)((List)((SeqLike)pairs.map((Function1)new Serializable(this){

                        public final IAllele apply(Tuple2<IAllele, IMutation> x$2) {
                            return (IAllele)x$2._1();
                        }
                    }, List$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable(this, pairs){
                        private final List pairs$1;

                        public final Tuple2<IAllele, List<IMutation>> apply(IAllele dsp) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dsp), ((List)this.pairs$1.filter((Function1)new Serializable(this, dsp){
                                private final IAllele dsp$1;

                                public final boolean apply(Tuple2<IAllele, IMutation> x$3) {
                                    Object object = x$3._1();
                                    IAllele iAllele = this.dsp$1;
                                    return !(object != null ? !object.equals(iAllele) : iAllele != null);
                                }
                                {
                                    this.dsp$1 = dsp$1;
                                }
                            })).map((Function1)new Serializable(this){

                                public final IMutation apply(Tuple2<IAllele, IMutation> x$4) {
                                    return (IMutation)x$4._2();
                                }
                            }, List$.MODULE$.canBuildFrom()));
                        }
                        {
                            this.pairs$1 = pairs$1;
                        }
                    }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){

                        public final boolean apply(Tuple2<IAllele, List<IMutation>> x0$2) {
                            Tuple2<IAllele, List<IMutation>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                List results = (List)tuple2._2();
                                boolean bl = results.size() > 1;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    })).foreach((Function1)new Serializable(this, sp1){
                        private final IAlleleSpecies sp1$1;

                        public final void apply(Tuple2<IAllele, List<IMutation>> x0$3) {
                            Tuple2<IAllele, List<IMutation>> tuple2 = x0$3;
                            if (tuple2 != null) {
                                IAllele partner = (IAllele)tuple2._1();
                                List results = (List)tuple2._2();
                                String names = ((TraversableOnce)results.map((Function1)new Serializable(this){

                                    public final String apply(IMutation mutation) {
                                        return new StringBuilder().append((Object)mutation.getTemplate()[0].getName()).append((Object)(BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)mutation.getSpecialConditions()).map((Function1)new Serializable(this){

                                            public final int apply(Collection<String> x$5) {
                                                return x$5.size();
                                            }
                                        }).getOrElse((Function0)new Serializable(this){

                                            public final int apply() {
                                                return this.apply$mcI$sp();
                                            }

                                            public int apply$mcI$sp() {
                                                return 0;
                                            }
                                        })) > 0 ? "*" : "")).toString();
                                    }
                                }, List$.MODULE$.canBuildFrom())).mkString(", ");
                                Gendustry$.MODULE$.logInfo("%s + %s => [%s]", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sp1$1.getName(), partner.getName(), names}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.sp1$1 = sp1$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Gendustry$.MODULE$.logInfo("%d mutation outputs", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.speciesResultMutations().size())}));
        Gendustry$.MODULE$.logInfo("%d mutation inputs", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.speciesUsedMutations().size())}));
        Misc$.MODULE$.filterType(JavaConversions$.MODULE$.collectionAsScalaIterable(AlleleManager.alleleRegistry.getRegisteredAlleles().values()), IAlleleSpecies.class).foreach((Function1)new Serializable(){

            public final void apply(IAlleleSpecies species) {
                if (species.getRoot().getTemplate(species.getUID()) == null) {
                    Gendustry$.MODULE$.logWarn("getTemplate returned null for species %s (root: %s)", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{species.getUID(), species.getRoot().getUID()}));
                } else {
                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])species.getRoot().getTemplate(species.getUID())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(this){

                        public final boolean apply(Tuple2<IAllele, Object> check$ifrefutable$2) {
                            Tuple2<IAllele, Object> tuple2 = check$ifrefutable$2;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).foreach((Function1)new Serializable(this, species){
                        private final IAlleleSpecies species$1;

                        public final void apply(Tuple2<IAllele, Object> x$6) {
                            Tuple2<IAllele, Object> tuple2 = x$6;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                IAllele allele = (IAllele)tuple2._1();
                                int chromosome = tuple2._2$mcI$sp();
                                if (allele == null || AlleleManager.alleleRegistry.isBlacklisted(allele.getUID())) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    GeneSampleInfo geneSampleInfo = new GeneSampleInfo(this.species$1.getRoot(), chromosome, allele);
                                    GeneticsCache$.MODULE$.speciesChromosomes().update((Object)geneSampleInfo, (Object)((SetLike)GeneticsCache$.MODULE$.speciesChromosomes().apply((Object)geneSampleInfo)).$plus((Object)this.species$1));
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.species$1 = species$1;
                        }
                    });
                }
            }
        });
        this.geneSamples_$eq((SortedSet<GeneSampleInfo>)((SortedSet)this.geneSamples().$plus$plus((GenTraversableOnce)this.speciesChromosomes().keys())));
        Gendustry$.MODULE$.logInfo("%d chromosomes", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.speciesChromosomes().size())}));
        Gendustry$.MODULE$.logInfo("Done", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private GeneticsCache$() {
        MODULE$ = this;
        this.speciesResultMutations = Map$.MODULE$.empty().withDefault((Function1)new anonfun.1());
        this.speciesUsedMutations = Map$.MODULE$.empty().withDefault((Function1)new anonfun.2());
        this.speciesChromosomes = Map$.MODULE$.empty().withDefault((Function1)new anonfun.3());
        this.geneSamples = SortedSet$.MODULE$.empty((Ordering)GeneticsCache$SampleOrdering$.MODULE$);
    }
}

