/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.generators.controllers.steam;

import net.bdew.generators.Generators$;
import net.bdew.generators.GeneratorsResourceProvider$;
import net.bdew.generators.config.Modules$PowerCapacitor$;
import net.bdew.generators.controllers.steam.MachineSteamTurbine$;
import net.bdew.lib.block.BlockRef;
import net.bdew.lib.data.DataSlotDouble;
import net.bdew.lib.data.DataSlotDouble$;
import net.bdew.lib.data.DataSlotInt;
import net.bdew.lib.data.DataSlotInt$;
import net.bdew.lib.data.DataSlotMovingAverage;
import net.bdew.lib.data.DataSlotTank;
import net.bdew.lib.data.base.DataSlotVal;
import net.bdew.lib.data.base.DataSlotVal$;
import net.bdew.lib.data.base.TileDataSlots;
import net.bdew.lib.data.base.UpdateKind$;
import net.bdew.lib.multiblock.data.DataSlotBlockFaceMap;
import net.bdew.lib.multiblock.data.DataSlotOutputConfig;
import net.bdew.lib.multiblock.data.OutputConfig;
import net.bdew.lib.multiblock.interact.CIFluidInput;
import net.bdew.lib.multiblock.interact.CIOutputFaces;
import net.bdew.lib.multiblock.interact.CIPowerProducer;
import net.bdew.lib.multiblock.tile.TileController;
import net.bdew.lib.multiblock.tile.TileControllerGui;
import net.bdew.lib.multiblock.tile.TileModule;
import net.bdew.lib.power.DataSlotPower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import scala.Enumeration;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u00015\u0011!\u0004V5mKN#X-Y7UkJ\u0014\u0017N\\3D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u000bM$X-Y7\u000b\u0005\u00151\u0011aC2p]R\u0014x\u000e\u001c7feNT!a\u0002\u0005\u0002\u0015\u001d,g.\u001a:bi>\u00148O\u0003\u0002\n\u0015\u0005!!\rZ3x\u0015\u0005Y\u0011a\u00018fi\u000e\u00011#\u0002\u0001\u000f1y\t\u0003CA\b\u0017\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011!\u0018\u000e\\3\u000b\u0005M!\u0012AC7vYRL'\r\\8dW*\u0011Q\u0003C\u0001\u0004Y&\u0014\u0017BA\f\u0011\u0005E!\u0016\u000e\\3D_:$(o\u001c7mKJ<U/\u001b\t\u00033qi\u0011A\u0007\u0006\u00037I\t\u0001\"\u001b8uKJ\f7\r^\u0005\u0003;i\u0011AbQ%GYVLG-\u00138qkR\u0004\"!G\u0010\n\u0005\u0001R\"!D\"J\u001fV$\b/\u001e;GC\u000e,7\u000f\u0005\u0002\u001aE%\u00111E\u0007\u0002\u0010\u0007&\u0003vn^3s!J|G-^2fe\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011A\u0001\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u0003\r\u0019gmZ\u000b\u0002Y9\u0011\u0001&L\u0005\u0003]\t\t1#T1dQ&tWm\u0015;fC6$VO\u001d2j]\u0016Da\u0001\r\u0001!\u0002\u0013a\u0013\u0001B2gO\u0002BqA\r\u0001C\u0002\u0013\u00051'A\u0005sKN|WO]2fgV\tAG\u0004\u00026m5\ta!\u0003\u00028\r\u0005Qr)\u001a8fe\u0006$xN]:SKN|WO]2f!J|g/\u001b3fe\"1\u0011\b\u0001Q\u0001\nQ\n!B]3t_V\u00148-Z:!\u0011\u001d\u0019\u0001A1A\u0005\u0002m*\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fQ\tA\u0001Z1uC&\u0011\u0011I\u0010\u0002\r\t\u0006$\u0018m\u00157piR\u000bgn\u001b\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u001f\u0002\rM$X-Y7!\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000bQ\u0001]8xKJ,\u0012a\u0012\t\u0003\u0011*k\u0011!\u0013\u0006\u0003\u000bRI!aS%\u0003\u001b\u0011\u000bG/Y*m_R\u0004vn^3s\u0011\u0019i\u0005\u0001)A\u0005\u000f\u00061\u0001o\\<fe\u0002Bqa\u0014\u0001C\u0002\u0013\u0005\u0001+A\u0003ta\u0016,G-F\u0001R!\ti$+\u0003\u0002T}\tqA)\u0019;b'2|G\u000fR8vE2,\u0007BB+\u0001A\u0003%\u0011+\u0001\u0004ta\u0016,G\r\t\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0003-qW/\u001c+ve\nLg.Z:\u0016\u0003e\u0003\"!\u0010.\n\u0005ms$a\u0003#bi\u0006\u001cFn\u001c;J]RDa!\u0018\u0001!\u0002\u0013I\u0016\u0001\u00048v[R+(OY5oKN\u0004\u0003bB0\u0001\u0005\u0004%\t\u0001Y\u0001\u000e_V$\b/\u001e;Bm\u0016\u0014\u0018mZ3\u0016\u0003\u0005\u0004\"!\u00102\n\u0005\rt$!\u0006#bi\u0006\u001cFn\u001c;N_ZLgnZ!wKJ\fw-\u001a\u0005\u0007K\u0002\u0001\u000b\u0011B1\u0002\u001d=,H\u000f];u\u0003Z,'/Y4fA!9q\r\u0001b\u0001\n\u0003\u0001\u0017\u0001D:uK\u0006l\u0017I^3sC\u001e,\u0007BB5\u0001A\u0003%\u0011-A\u0007ti\u0016\fW.\u0011<fe\u0006<W\r\t\u0005\tW\u0002A)\u0019!C\u0001Y\u0006QQ.\u0019=PkR\u0004X\u000f^:\u0016\u00035\u0004\"A\\9\u000e\u0003=T\u0011\u0001]\u0001\u0006g\u000e\fG.Y\u0005\u0003e>\u00141!\u00138u\u0011!!\b\u0001#A!B\u0013i\u0017aC7bq>+H\u000f];ug\u0002BQA\u001e\u0001\u0005\u0002]\f\u0001\u0002Z8Va\u0012\fG/\u001a\u000b\u0002qB\u0011a._\u0005\u0003u>\u0014A!\u00168ji\")A\u0010\u0001C!{\u00069q\u000e]3o\u000fVLGC\u0001=\u007f\u0011\u0019y8\u00101\u0001\u0002\u0002\u00051\u0001\u000f\\1zKJ\u0004B!a\u0001\u0002\u00105\u0011\u0011Q\u0001\u0006\u0004\u007f\u0006\u001d!\u0002BA\u0005\u0003\u0017\ta!\u001a8uSRL(bAA\u0007\u0015\u0005IQ.\u001b8fGJ\fg\r^\u0005\u0005\u0003#\t)A\u0001\u0007F]RLG/\u001f)mCf,'\u000fC\u0004\u0002\u0016\u0001!\t!a\u0006\u0002\u0015%t\u0007/\u001e;GYVLG\rF\u0003n\u00033\ti\u0003\u0003\u0005\u0002\u001c\u0005M\u0001\u0019AA\u000f\u0003!\u0011Xm]8ve\u000e,\u0007\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0007M2,\u0018\u000eZ:\u000b\u0007\u0005\u001d\"\"\u0001\bnS:,7M]1gi\u001a|'oZ3\n\t\u0005-\u0012\u0011\u0005\u0002\u000b\r2,\u0018\u000eZ*uC\u000e\\\u0007\u0002CA\u0018\u0003'\u0001\r!!\r\u0002\r\u0011|g)\u001b7m!\rq\u00171G\u0005\u0004\u0003ky'a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003s\u0001A\u0011AA\u001e\u00035\u0019\u0017M\\%oaV$h\t\\;jIR!\u0011\u0011GA\u001f\u0011!\ty$a\u000eA\u0002\u0005\u0005\u0013!\u00024mk&$\u0007\u0003BA\u0010\u0003\u0007JA!!\u0012\u0002\"\t)a\t\\;jI\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0013aC4fiR\u000bgn[%oM>,\"!!\u0014\u0011\u000b9\fy%a\u0015\n\u0007\u0005EsNA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002 \u0005U\u0013\u0002BA,\u0003C\u0011QB\u00127vS\u0012$\u0016M\\6J]\u001a|\u0007bBA.\u0001\u0011\u0005\u0011QL\u0001\bKb$(/Y2u)\u0019\ty&!\u001a\u0002jA\u0019a.!\u0019\n\u0007\u0005\rtNA\u0003GY>\fG\u000f\u0003\u0005\u0002h\u0005e\u0003\u0019AA0\u0003\u00051\b\u0002CA6\u00033\u0002\r!!\r\u0002\u0011MLW.\u001e7bi\u0016Da!a\u001c\u0001\t\u00039\u0018\u0001E8o\u001b>$W\u000f\\3t\u0007\"\fgnZ3e\u0001")
public class TileSteamTurbineController
extends TileControllerGui
implements CIFluidInput,
CIPowerProducer {
    private final MachineSteamTurbine$ cfg;
    private final GeneratorsResourceProvider$ resources;
    private final DataSlotTank steam;
    private final DataSlotPower power;
    private final DataSlotDouble speed;
    private final DataSlotInt numTurbines;
    private final DataSlotMovingAverage outputAverage;
    private final DataSlotMovingAverage steamAverage;
    private int maxOutputs;
    private final DataSlotBlockFaceMap outputFaces;
    private final DataSlotOutputConfig outputConfig;
    private volatile boolean bitmap$0;

    private int maxOutputs$lzycompute() {
        TileSteamTurbineController tileSteamTurbineController = this;
        synchronized (tileSteamTurbineController) {
            if (!this.bitmap$0) {
                this.maxOutputs = 6;
                this.bitmap$0 = true;
            }
            return this.maxOutputs;
        }
    }

    public DataSlotBlockFaceMap outputFaces() {
        return this.outputFaces;
    }

    public DataSlotOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public /* synthetic */ void net$bdew$lib$multiblock$interact$CIOutputFaces$$super$moduleRemoved(TileModule module) {
        TileController.class.moduleRemoved((TileController)this, (TileModule)module);
    }

    public void net$bdew$lib$multiblock$interact$CIOutputFaces$_setter_$outputFaces_$eq(DataSlotBlockFaceMap x$1) {
        this.outputFaces = x$1;
    }

    public void net$bdew$lib$multiblock$interact$CIOutputFaces$_setter_$outputConfig_$eq(DataSlotOutputConfig x$1) {
        this.outputConfig = x$1;
    }

    public int newOutput(BlockRef bp, ForgeDirection face, OutputConfig cfg) {
        return CIOutputFaces.class.newOutput((CIOutputFaces)this, (BlockRef)bp, (ForgeDirection)face, (OutputConfig)cfg);
    }

    public void moduleRemoved(TileModule module) {
        CIOutputFaces.class.moduleRemoved((CIOutputFaces)this, (TileModule)module);
    }

    public void doOutputs() {
        CIOutputFaces.class.doOutputs((CIOutputFaces)this);
    }

    public void removeOutput(BlockRef bp, ForgeDirection face) {
        CIOutputFaces.class.removeOutput((CIOutputFaces)this, (BlockRef)bp, (ForgeDirection)face);
    }

    public MachineSteamTurbine$ cfg() {
        return this.cfg;
    }

    public GeneratorsResourceProvider$ resources() {
        return this.resources;
    }

    public DataSlotTank steam() {
        return this.steam;
    }

    public DataSlotPower power() {
        return this.power;
    }

    public DataSlotDouble speed() {
        return this.speed;
    }

    public DataSlotInt numTurbines() {
        return this.numTurbines;
    }

    public DataSlotMovingAverage outputAverage() {
        return this.outputAverage;
    }

    public DataSlotMovingAverage steamAverage() {
        return this.steamAverage;
    }

    public int maxOutputs() {
        return this.bitmap$0 ? this.maxOutputs : this.maxOutputs$lzycompute();
    }

    public void doUpdate() {
        if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) > 1.0 && this.power().stored() < this.power().capacity()) {
            double canGenerate = Math.min(BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) / this.cfg().effectiveRPM(), 1.0) * (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines())) * this.cfg().mjPerTickPerTurbine();
            double injected = Math.min(canGenerate, (double)(this.power().capacity() - this.power().stored()));
            this.power().stored_$eq(this.power().stored() + (float)injected);
            this.outputAverage().update(injected);
            this.speed().$minus$eq((Object)BoxesRunTime.boxToDouble((double)(this.cfg().maxRPM() * this.cfg().spinDownMultiplier() * (injected / (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines())) / this.cfg().mjPerTickPerTurbine()))));
            if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) < 1.0) {
                this.speed().$colon$eq((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            this.lastChange_$eq(this.field_145850_b.func_82737_E());
        } else {
            this.outputAverage().update(0.0);
        }
        if (this.steam().getFluidAmount() > 0) {
            double steamPerTick = this.cfg().steamPerTickPerTurbine() * (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines()));
            double canUseSteam = Math.min((double)this.steam().getFluidAmount(), steamPerTick);
            this.steam().drain((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(canUseSteam)), true);
            if (canUseSteam / steamPerTick * this.cfg().maxRPM() > BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed()))) {
                this.speed().$plus$eq((Object)BoxesRunTime.boxToDouble((double)((canUseSteam / steamPerTick * this.cfg().maxRPM() - BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed()))) * this.cfg().spinUpMultiplier())));
            }
            this.steamAverage().update(canUseSteam);
        } else {
            this.steamAverage().update(0.0);
        }
        if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) > this.cfg().maxRPM()) {
            this.speed().$colon$eq((Object)BoxesRunTime.boxToDouble((double)this.cfg().maxRPM()));
        }
    }

    public void openGui(EntityPlayer player) {
        player.openGui((Object)Generators$.MODULE$, this.cfg().guiId(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int inputFluid(FluidStack resource2, boolean doFill) {
        return this.canInputFluid(resource2.getFluid()) ? this.steam().fill(resource2, doFill) : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canInputFluid(Fluid fluid) {
        if (fluid == null) return false;
        String string = fluid.getName();
        String string2 = "steam";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public FluidTankInfo[] getTankInfo() {
        return (FluidTankInfo[])((Object[])new FluidTankInfo[]{this.steam().getInfo()});
    }

    public float extract(float v, boolean simulate) {
        return this.power().extract(v, simulate);
    }

    public void onModulesChanged() {
        this.power().capacity_$eq((float)(this.getNumOfModules("PowerCapacitor") * Modules$PowerCapacitor$.MODULE$.capacity() + this.cfg().internalPowerCapacity()));
        this.numTurbines().$colon$eq((Object)BoxesRunTime.boxToInteger((int)this.getNumOfModules("Turbine")));
    }

    public TileSteamTurbineController() {
        CIOutputFaces.class.$init$((CIOutputFaces)this);
        this.cfg = MachineSteamTurbine$.MODULE$;
        this.resources = GeneratorsResourceProvider$.MODULE$;
        this.steam = new DataSlotTank("steam", (TileDataSlots)this, this.cfg().internalSteamCapacity());
        this.power = new DataSlotPower("power", (TileDataSlots)this);
        this.speed = (DataSlotDouble)new DataSlotDouble("speed", (TileDataSlots)this, DataSlotDouble$.MODULE$.$lessinit$greater$default$3()).setUpdate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.GUI(), UpdateKind$.MODULE$.SAVE()}));
        this.numTurbines = (DataSlotInt)new DataSlotInt("turbines", (TileDataSlots)this, DataSlotInt$.MODULE$.$lessinit$greater$default$3()).setUpdate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.GUI()}));
        this.outputAverage = new DataSlotMovingAverage("outputAverage", (TileDataSlots)this, 20);
        this.steamAverage = new DataSlotMovingAverage("steamAverage", (TileDataSlots)this, 20);
        this.serverTick().listen((Object)new Serializable(this){
            private final /* synthetic */ TileSteamTurbineController $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.doUpdate();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

