/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.generators.controllers.steam;

import net.bdew.generators.Generators$;
import net.bdew.generators.GeneratorsResourceProvider$;
import net.bdew.generators.config.Modules$PowerCapacitor$;
import net.bdew.generators.controllers.PoweredController;
import net.bdew.generators.controllers.steam.MachineSteamTurbine$;
import net.bdew.generators.sensor.Sensors$;
import net.bdew.lib.block.BlockRef;
import net.bdew.lib.data.DataSlotDouble;
import net.bdew.lib.data.DataSlotDouble$;
import net.bdew.lib.data.DataSlotInt;
import net.bdew.lib.data.DataSlotInt$;
import net.bdew.lib.data.DataSlotMovingAverage;
import net.bdew.lib.data.DataSlotTank;
import net.bdew.lib.data.base.DataSlotContainer;
import net.bdew.lib.data.base.DataSlotVal;
import net.bdew.lib.data.base.DataSlotVal$;
import net.bdew.lib.data.base.UpdateKind$;
import net.bdew.lib.multiblock.data.DataSlotBlockFaceMap;
import net.bdew.lib.multiblock.data.DataSlotOutputConfig;
import net.bdew.lib.multiblock.data.OutputConfig;
import net.bdew.lib.multiblock.interact.CIFluidInput;
import net.bdew.lib.multiblock.interact.CIOutputFaces;
import net.bdew.lib.multiblock.interact.CIPowerProducer;
import net.bdew.lib.multiblock.tile.TileController;
import net.bdew.lib.multiblock.tile.TileControllerGui;
import net.bdew.lib.multiblock.tile.TileModule;
import net.bdew.lib.power.DataSlotPower;
import net.bdew.lib.sensors.SensorSystem;
import net.bdew.lib.sensors.multiblock.CIRedstoneSensors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import scala.Enumeration;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u00015\u0011!\u0004V5mKN#X-Y7UkJ\u0014\u0017N\\3D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u000bM$X-Y7\u000b\u0005\u00151\u0011aC2p]R\u0014x\u000e\u001c7feNT!a\u0002\u0005\u0002\u0015\u001d,g.\u001a:bi>\u00148O\u0003\u0002\n\u0015\u0005!!\rZ3x\u0015\u0005Y\u0011a\u00018fi\u000e\u00011c\u0002\u0001\u000f1q\u0011S\u0005\u000b\t\u0003\u001fYi\u0011\u0001\u0005\u0006\u0003#I\tA\u0001^5mK*\u00111\u0003F\u0001\u000b[VdG/\u001b2m_\u000e\\'BA\u000b\t\u0003\ra\u0017NY\u0005\u0003/A\u0011\u0011\u0003V5mK\u000e{g\u000e\u001e:pY2,'oR;j!\tI\"$D\u0001\u0005\u0013\tYBAA\tQ_^,'/\u001a3D_:$(o\u001c7mKJ\u0004\"!\b\u0011\u000e\u0003yQ!a\b\n\u0002\u0011%tG/\u001a:bGRL!!\t\u0010\u0003\u0019\rKe\t\\;jI&s\u0007/\u001e;\u0011\u0005u\u0019\u0013B\u0001\u0013\u001f\u00055\u0019\u0015jT;uaV$h)Y2fgB\u0011QDJ\u0005\u0003Oy\u0011qbQ%Q_^,'\u000f\u0015:pIV\u001cWM\u001d\t\u0003S5j\u0011A\u000b\u0006\u0003'-R!\u0001\f\u000b\u0002\u000fM,gn]8sg&\u0011aF\u000b\u0002\u0012\u0007&\u0013V\rZ:u_:,7+\u001a8t_J\u001c\b\"\u0002\u0019\u0001\t\u0003\t\u0014A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001\u0003\u0011\u001d)\u0004A1A\u0005\u0002Y\n1a\u00194h+\u00059dBA\u001a9\u0013\tI$!A\nNC\u000eD\u0017N\\3Ti\u0016\fW\u000eV;sE&tW\r\u0003\u0004<\u0001\u0001\u0006IaN\u0001\u0005G\u001a<\u0007\u0005C\u0004>\u0001\t\u0007I\u0011\u0001 \u0002\u0013I,7o\\;sG\u0016\u001cX#A \u000f\u0005\u0001\u000bU\"\u0001\u0004\n\u0005\t3\u0011AG$f]\u0016\u0014\u0018\r^8sgJ+7o\\;sG\u0016\u0004&o\u001c<jI\u0016\u0014\bB\u0002#\u0001A\u0003%q(\u0001\u0006sKN|WO]2fg\u0002Bqa\u0001\u0001C\u0002\u0013\u0005a)F\u0001H!\tA5*D\u0001J\u0015\tQE#\u0001\u0003eCR\f\u0017B\u0001'J\u00051!\u0015\r^1TY>$H+\u00198l\u0011\u0019q\u0005\u0001)A\u0005\u000f\u000611\u000f^3b[\u0002Bq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011+A\u0003q_^,'/F\u0001S!\t\u0019V+D\u0001U\u0015\t\u0001F#\u0003\u0002W)\niA)\u0019;b'2|G\u000fU8xKJDa\u0001\u0017\u0001!\u0002\u0013\u0011\u0016A\u00029po\u0016\u0014\b\u0005C\u0004[\u0001\t\u0007I\u0011A.\u0002\u000bM\u0004X-\u001a3\u0016\u0003q\u0003\"\u0001S/\n\u0005yK%A\u0004#bi\u0006\u001cFn\u001c;E_V\u0014G.\u001a\u0005\u0007A\u0002\u0001\u000b\u0011\u0002/\u0002\rM\u0004X-\u001a3!\u0011\u001d\u0011\u0007A1A\u0005\u0002\r\f1B\\;n)V\u0014(-\u001b8fgV\tA\r\u0005\u0002IK&\u0011a-\u0013\u0002\f\t\u0006$\u0018m\u00157pi&sG\u000f\u0003\u0004i\u0001\u0001\u0006I\u0001Z\u0001\r]VlG+\u001e:cS:,7\u000f\t\u0005\bU\u0002\u0011\r\u0011\"\u0001l\u00035yW\u000f\u001e9vi\u00063XM]1hKV\tA\u000e\u0005\u0002I[&\u0011a.\u0013\u0002\u0016\t\u0006$\u0018m\u00157pi6{g/\u001b8h\u0003Z,'/Y4f\u0011\u0019\u0001\b\u0001)A\u0005Y\u0006qq.\u001e;qkR\fe/\u001a:bO\u0016\u0004\u0003b\u0002:\u0001\u0005\u0004%\ta[\u0001\rgR,\u0017-\\!wKJ\fw-\u001a\u0005\u0007i\u0002\u0001\u000b\u0011\u00027\u0002\u001bM$X-Y7Bm\u0016\u0014\u0018mZ3!\u0011!1\b\u0001#b\u0001\n\u00039\u0018AC7bq>+H\u000f];ugV\t\u0001\u0010\u0005\u0002zy6\t!PC\u0001|\u0003\u0015\u00198-\u00197b\u0013\ti(PA\u0002J]RD\u0001b \u0001\t\u0002\u0003\u0006K\u0001_\u0001\f[\u0006Dx*\u001e;qkR\u001c\b\u0005C\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0011\u0002\u0006\u0005\u0019\"/\u001a3ti>tWmU3og>\u00148\u000fV=qKV\u0011\u0011q\u0001\t\u0007\u0003\u0013\t\u0019\"a\u0006\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005E!0\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\f\t!A*[:u%\u0011\tI\"!\n\u0007\r\u0005m\u0001\u0001AA\f\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0013\u0011\ty\"!\t\u0002\u000fM+gn]8sg*\u0019\u00111\u0005\u0004\u0002\rM,gn]8s!\u0011\t9#a\u000b\u000f\t\u0005%\u0012QD\u0007\u0003\u0003CIA!!\f\u00020\ta1+[7qY\u0016\u001cVM\\:pe&\u0019\u0011\u0011G\u0016\u0003\u0019M+gn]8s'f\u001cH/Z7\t\u0011\u0005U\u0012\u0011\u0004D\u0001\u0003o\t!\u0002]1sC6,G/\u001a:t+\t\tI\u0004\u0005\u0004\u0002\n\u0005m\u0012qH\u0005\u0005\u0003{\tYA\u0001\u0004WK\u000e$xN\u001d\t\u0005\u0003O\t\t%\u0003\u0003\u0002D\u0005=\"aD*j[BdW\rU1sC6,G/\u001a:\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u000f\tAC]3egR|g.Z*f]N|'o\u001d+za\u0016\u0004\u0003\"CA&\u0001\t\u0007I\u0011IA'\u0003Q\u0011X\rZ:u_:,7+\u001a8t_J\u001c\u0016p\u001d;f[V\u0011\u0011q\u0005\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002(\u0005)\"/\u001a3ti>tWmU3og>\u00148+_:uK6\u0004\u0003bBA+\u0001\u0011\u0005\u0011qK\u0001\tI>,\u0006\u000fZ1uKR\u0011\u0011\u0011\f\t\u0004s\u0006m\u0013bAA/u\n!QK\\5u\u0011\u001d\t\t\u0007\u0001C!\u0003G\nqa\u001c9f]\u001e+\u0018\u000e\u0006\u0003\u0002Z\u0005\u0015\u0004\u0002CA4\u0003?\u0002\r!!\u001b\u0002\rAd\u0017-_3s!\u0011\tY'a\u001e\u000e\u0005\u00055$\u0002BA4\u0003_RA!!\u001d\u0002t\u00051QM\u001c;jifT1!!\u001e\u000b\u0003%i\u0017N\\3de\u00064G/\u0003\u0003\u0002z\u00055$\u0001D#oi&$\u0018\u0010\u00157bs\u0016\u0014\bbBA?\u0001\u0011\u0005\u0011qP\u0001\u000bS:\u0004X\u000f\u001e$mk&$G#\u0002=\u0002\u0002\u0006U\u0005\u0002CAB\u0003w\u0002\r!!\"\u0002\u0011I,7o\\;sG\u0016\u0004B!a\"\u0002\u00126\u0011\u0011\u0011\u0012\u0006\u0005\u0003\u0017\u000bi)\u0001\u0004gYVLGm\u001d\u0006\u0004\u0003\u001fS\u0011AD7j]\u0016\u001c'/\u00194uM>\u0014x-Z\u0005\u0005\u0003'\u000bII\u0001\u0006GYVLGm\u0015;bG.D\u0001\"a&\u0002|\u0001\u0007\u0011\u0011T\u0001\u0007I>4\u0015\u000e\u001c7\u0011\u0007e\fY*C\u0002\u0002\u001ej\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002\"\u0002!\t!a)\u0002\u001b\r\fg.\u00138qkR4E.^5e)\u0011\tI*!*\t\u0011\u0005\u001d\u0016q\u0014a\u0001\u0003S\u000bQA\u001a7vS\u0012\u0004B!a\"\u0002,&!\u0011QVAE\u0005\u00151E.^5e\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000b1bZ3u)\u0006t7.\u00138g_V\u0011\u0011Q\u0017\t\u0006s\u0006]\u00161X\u0005\u0004\u0003sS(!B!se\u0006L\b\u0003BAD\u0003{KA!a0\u0002\n\nia\t\\;jIR\u000bgn[%oM>Dq!a1\u0001\t\u0003\t)-A\u0004fqR\u0014\u0018m\u0019;\u0015\r\u0005\u001d\u0017QZAi!\rI\u0018\u0011Z\u0005\u0004\u0003\u0017T(!\u0002$m_\u0006$\b\u0002CAh\u0003\u0003\u0004\r!a2\u0002\u0003YD\u0001\"a5\u0002B\u0002\u0007\u0011\u0011T\u0001\tg&lW\u000f\\1uK\"9\u0011q\u001b\u0001\u0005\u0002\u0005]\u0013\u0001E8o\u001b>$W\u000f\\3t\u0007\"\fgnZ3e\u0001")
public class TileSteamTurbineController
extends TileControllerGui
implements PoweredController,
CIFluidInput,
CIPowerProducer,
CIRedstoneSensors {
    private final MachineSteamTurbine$ cfg;
    private final GeneratorsResourceProvider$ resources;
    private final DataSlotTank steam;
    private final DataSlotPower power;
    private final DataSlotDouble speed;
    private final DataSlotInt numTurbines;
    private final DataSlotMovingAverage outputAverage;
    private final DataSlotMovingAverage steamAverage;
    private int maxOutputs;
    private final List<SensorSystem.SimpleSensor> redstoneSensorsType;
    private final Sensors$ redstoneSensorSystem;
    private final DataSlotBlockFaceMap outputFaces;
    private final DataSlotOutputConfig outputConfig;
    private volatile boolean bitmap$0;

    private int maxOutputs$lzycompute() {
        TileSteamTurbineController tileSteamTurbineController = this;
        synchronized (tileSteamTurbineController) {
            if (!this.bitmap$0) {
                this.maxOutputs = 6;
                this.bitmap$0 = true;
            }
            return this.maxOutputs;
        }
    }

    public DataSlotBlockFaceMap outputFaces() {
        return this.outputFaces;
    }

    public DataSlotOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public /* synthetic */ void net$bdew$lib$multiblock$interact$CIOutputFaces$$super$moduleRemoved(TileModule module) {
        TileController.class.moduleRemoved((TileController)this, (TileModule)module);
    }

    public void net$bdew$lib$multiblock$interact$CIOutputFaces$_setter_$outputFaces_$eq(DataSlotBlockFaceMap x$1) {
        this.outputFaces = x$1;
    }

    public void net$bdew$lib$multiblock$interact$CIOutputFaces$_setter_$outputConfig_$eq(DataSlotOutputConfig x$1) {
        this.outputConfig = x$1;
    }

    public int newOutput(BlockRef bp, ForgeDirection face, OutputConfig cfg) {
        return CIOutputFaces.class.newOutput((CIOutputFaces)this, (BlockRef)bp, (ForgeDirection)face, (OutputConfig)cfg);
    }

    public void moduleRemoved(TileModule module) {
        CIOutputFaces.class.moduleRemoved((CIOutputFaces)this, (TileModule)module);
    }

    public void doOutputs() {
        CIOutputFaces.class.doOutputs((CIOutputFaces)this);
    }

    public void removeOutput(BlockRef bp, ForgeDirection face) {
        CIOutputFaces.class.removeOutput((CIOutputFaces)this, (BlockRef)bp, (ForgeDirection)face);
    }

    public MachineSteamTurbine$ cfg() {
        return this.cfg;
    }

    public GeneratorsResourceProvider$ resources() {
        return this.resources;
    }

    public DataSlotTank steam() {
        return this.steam;
    }

    @Override
    public DataSlotPower power() {
        return this.power;
    }

    public DataSlotDouble speed() {
        return this.speed;
    }

    public DataSlotInt numTurbines() {
        return this.numTurbines;
    }

    public DataSlotMovingAverage outputAverage() {
        return this.outputAverage;
    }

    public DataSlotMovingAverage steamAverage() {
        return this.steamAverage;
    }

    public int maxOutputs() {
        return this.bitmap$0 ? this.maxOutputs : this.maxOutputs$lzycompute();
    }

    public List<SensorSystem.SimpleSensor> redstoneSensorsType() {
        return this.redstoneSensorsType;
    }

    public Sensors$ redstoneSensorSystem() {
        return this.redstoneSensorSystem;
    }

    public void doUpdate() {
        if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) > 1.0 && this.power().stored() < this.power().capacity()) {
            double canGenerate = Math.min(BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) / this.cfg().effectiveRPM(), 1.0) * (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines())) * this.cfg().mjPerTickPerTurbine();
            double injected = Math.min(canGenerate, (double)(this.power().capacity() - this.power().stored()));
            this.power().stored_$eq(this.power().stored() + (float)injected);
            this.outputAverage().update(injected);
            this.speed().$minus$eq((Object)BoxesRunTime.boxToDouble((double)(this.cfg().maxRPM() * this.cfg().spinDownMultiplier() * (injected / (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines())) / this.cfg().mjPerTickPerTurbine()))));
            if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) < 1.0) {
                this.speed().$colon$eq((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            this.lastChange_$eq(this.field_145850_b.func_82737_E());
        } else {
            this.outputAverage().update(0.0);
        }
        if (this.steam().getFluidAmount() > 0) {
            double steamPerTick = this.cfg().steamPerTickPerTurbine() * (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines()));
            double canUseSteam = Math.min((double)this.steam().getFluidAmount(), steamPerTick);
            this.steam().drain((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(canUseSteam)), true);
            if (canUseSteam / steamPerTick * this.cfg().maxRPM() > BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed()))) {
                this.speed().$plus$eq((Object)BoxesRunTime.boxToDouble((double)((canUseSteam / steamPerTick * this.cfg().maxRPM() - BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed()))) * this.cfg().spinUpMultiplier())));
            }
            this.steamAverage().update(canUseSteam);
        } else {
            this.steamAverage().update(0.0);
        }
        if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) > this.cfg().maxRPM()) {
            this.speed().$colon$eq((Object)BoxesRunTime.boxToDouble((double)this.cfg().maxRPM()));
        }
    }

    public void openGui(EntityPlayer player) {
        player.openGui((Object)Generators$.MODULE$, this.cfg().guiId(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int inputFluid(FluidStack resource2, boolean doFill) {
        return this.canInputFluid(resource2.getFluid()) ? this.steam().fill(resource2, doFill) : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canInputFluid(Fluid fluid) {
        if (fluid == null) return false;
        String string = fluid.getName();
        String string2 = "steam";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public FluidTankInfo[] getTankInfo() {
        return (FluidTankInfo[])((Object[])new FluidTankInfo[]{this.steam().getInfo()});
    }

    public float extract(float v, boolean simulate) {
        return this.power().extract(v, simulate);
    }

    public void onModulesChanged() {
        this.power().capacity_$eq((float)(this.getNumOfModules("PowerCapacitor") * Modules$PowerCapacitor$.MODULE$.capacity() + this.cfg().internalPowerCapacity()));
        this.numTurbines().$colon$eq((Object)BoxesRunTime.boxToInteger((int)this.getNumOfModules("Turbine")));
    }

    public TileSteamTurbineController() {
        CIOutputFaces.class.$init$((CIOutputFaces)this);
        this.cfg = MachineSteamTurbine$.MODULE$;
        this.resources = GeneratorsResourceProvider$.MODULE$;
        this.steam = new DataSlotTank("steam", (DataSlotContainer)this, this.cfg().internalSteamCapacity());
        this.power = new DataSlotPower("power", (DataSlotContainer)this);
        this.speed = (DataSlotDouble)new DataSlotDouble("speed", (DataSlotContainer)this, DataSlotDouble$.MODULE$.$lessinit$greater$default$3()).setUpdate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.GUI(), UpdateKind$.MODULE$.SAVE()}));
        this.numTurbines = (DataSlotInt)new DataSlotInt("turbines", (DataSlotContainer)this, DataSlotInt$.MODULE$.$lessinit$greater$default$3()).setUpdate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.GUI()}));
        this.outputAverage = new DataSlotMovingAverage("outputAverage", (DataSlotContainer)this, 20);
        this.steamAverage = new DataSlotMovingAverage("steamAverage", (DataSlotContainer)this, 20);
        this.redstoneSensorsType = Sensors$.MODULE$.steamTurbineSensors();
        this.redstoneSensorSystem = Sensors$.MODULE$;
        this.serverTick().listen((Object)new Serializable(this){
            private final /* synthetic */ TileSteamTurbineController $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.doUpdate();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

