/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.generators.controllers.steam;

import net.bdew.generators.Generators$;
import net.bdew.generators.GeneratorsResourceProvider$;
import net.bdew.generators.config.Modules$PowerCapacitor$;
import net.bdew.generators.controllers.steam.MachineSteamTurbine$;
import net.bdew.generators.gui.DataSlotMovingAverage;
import net.bdew.lib.block.BlockRef;
import net.bdew.lib.data.DataSlotDouble;
import net.bdew.lib.data.DataSlotDouble$;
import net.bdew.lib.data.DataSlotInt;
import net.bdew.lib.data.DataSlotInt$;
import net.bdew.lib.data.DataSlotTank;
import net.bdew.lib.data.base.DataSlotVal;
import net.bdew.lib.data.base.DataSlotVal$;
import net.bdew.lib.data.base.TileDataSlots;
import net.bdew.lib.data.base.UpdateKind$;
import net.bdew.lib.multiblock.data.DataSlotBlockFaceMap;
import net.bdew.lib.multiblock.data.DataSlotOutputConfig;
import net.bdew.lib.multiblock.data.OutputConfig;
import net.bdew.lib.multiblock.interact.CIFluidInput;
import net.bdew.lib.multiblock.interact.CIOutputFaces;
import net.bdew.lib.multiblock.interact.CIPowerProducer;
import net.bdew.lib.multiblock.tile.TileController;
import net.bdew.lib.multiblock.tile.TileControllerGui;
import net.bdew.lib.multiblock.tile.TileModule;
import net.bdew.lib.power.DataSlotPower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import scala.Enumeration;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u00015\u0011!\u0004V5mKN#X-Y7UkJ\u0014\u0017N\\3D_:$(o\u001c7mKJT!a\u0001\u0003\u0002\u000bM$X-Y7\u000b\u0005\u00151\u0011aC2p]R\u0014x\u000e\u001c7feNT!a\u0002\u0005\u0002\u0015\u001d,g.\u001a:bi>\u00148O\u0003\u0002\n\u0015\u0005!!\rZ3x\u0015\u0005Y\u0011a\u00018fi\u000e\u00011#\u0002\u0001\u000f1y\t\u0003CA\b\u0017\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011!\u0018\u000e\\3\u000b\u0005M!\u0012AC7vYRL'\r\\8dW*\u0011Q\u0003C\u0001\u0004Y&\u0014\u0017BA\f\u0011\u0005E!\u0016\u000e\\3D_:$(o\u001c7mKJ<U/\u001b\t\u00033qi\u0011A\u0007\u0006\u00037I\t\u0001\"\u001b8uKJ\f7\r^\u0005\u0003;i\u0011AbQ%GYVLG-\u00138qkR\u0004\"!G\u0010\n\u0005\u0001R\"!D\"J\u001fV$\b/\u001e;GC\u000e,7\u000f\u0005\u0002\u001aE%\u00111E\u0007\u0002\u0010\u0007&\u0003vn^3s!J|G-^2fe\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011A\u0001\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u0003\r\u0019gmZ\u000b\u0002Y9\u0011\u0001&L\u0005\u0003]\t\t1#T1dQ&tWm\u0015;fC6$VO\u001d2j]\u0016Da\u0001\r\u0001!\u0002\u0013a\u0013\u0001B2gO\u0002BqA\r\u0001C\u0002\u0013\u00051'A\u0005sKN|WO]2fgV\tAG\u0004\u00026m5\ta!\u0003\u00028\r\u0005Qr)\u001a8fe\u0006$xN]:SKN|WO]2f!J|g/\u001b3fe\"1\u0011\b\u0001Q\u0001\nQ\n!B]3t_V\u00148-Z:!\u0011\u001d\u0019\u0001A1A\u0005\u0002m*\u0012\u0001\u0010\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fQ\tA\u0001Z1uC&\u0011\u0011I\u0010\u0002\r\t\u0006$\u0018m\u00157piR\u000bgn\u001b\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u001f\u0002\rM$X-Y7!\u0011\u001d)\u0005A1A\u0005\u0002\u0019\u000bQ\u0001]8xKJ,\u0012a\u0012\t\u0003\u0011*k\u0011!\u0013\u0006\u0003\u000bRI!aS%\u0003\u001b\u0011\u000bG/Y*m_R\u0004vn^3s\u0011\u0019i\u0005\u0001)A\u0005\u000f\u00061\u0001o\\<fe\u0002Bqa\u0014\u0001C\u0002\u0013\u0005\u0001+A\u0003ta\u0016,G-F\u0001R!\ti$+\u0003\u0002T}\tqA)\u0019;b'2|G\u000fR8vE2,\u0007BB+\u0001A\u0003%\u0011+\u0001\u0004ta\u0016,G\r\t\u0005\b/\u0002\u0011\r\u0011\"\u0001Y\u0003-qW/\u001c+ve\nLg.Z:\u0016\u0003e\u0003\"!\u0010.\n\u0005ms$a\u0003#bi\u0006\u001cFn\u001c;J]RDa!\u0018\u0001!\u0002\u0013I\u0016\u0001\u00048v[R+(OY5oKN\u0004\u0003bB0\u0001\u0005\u0004%\t\u0001Y\u0001\u000e_V$\b/\u001e;Bm\u0016\u0014\u0018mZ3\u0016\u0003\u0005\u0004\"AY3\u000e\u0003\rT!\u0001\u001a\u0004\u0002\u0007\u001d,\u0018.\u0003\u0002gG\n)B)\u0019;b'2|G/T8wS:<\u0017I^3sC\u001e,\u0007B\u00025\u0001A\u0003%\u0011-\u0001\bpkR\u0004X\u000f^!wKJ\fw-\u001a\u0011\t\u000f)\u0004!\u0019!C\u0001A\u0006a1\u000f^3b[\u00063XM]1hK\"1A\u000e\u0001Q\u0001\n\u0005\fQb\u001d;fC6\fe/\u001a:bO\u0016\u0004\u0003\u0002\u00038\u0001\u0011\u000b\u0007I\u0011A8\u0002\u00155\f\u0007pT;uaV$8/F\u0001q!\t\tH/D\u0001s\u0015\u0005\u0019\u0018!B:dC2\f\u0017BA;s\u0005\rIe\u000e\u001e\u0005\to\u0002A\t\u0011)Q\u0005a\u0006YQ.\u0019=PkR\u0004X\u000f^:!\u0011\u0015I\b\u0001\"\u0001{\u0003!!w.\u00169eCR,G#A>\u0011\u0005Ed\u0018BA?s\u0005\u0011)f.\u001b;\t\r}\u0004A\u0011IA\u0001\u0003\u001dy\u0007/\u001a8Hk&$2a_A\u0002\u0011\u001d\t)A a\u0001\u0003\u000f\ta\u0001\u001d7bs\u0016\u0014\b\u0003BA\u0005\u0003+i!!a\u0003\u000b\t\u0005\u0015\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0004f]RLG/\u001f\u0006\u0004\u0003'Q\u0011!C7j]\u0016\u001c'/\u00194u\u0013\u0011\t9\"a\u0003\u0003\u0019\u0015sG/\u001b;z!2\f\u00170\u001a:\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005Q\u0011N\u001c9vi\u001acW/\u001b3\u0015\u000bA\fy\"a\r\t\u0011\u0005\u0005\u0012\u0011\u0004a\u0001\u0003G\t\u0001B]3t_V\u00148-\u001a\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003\u00191G.^5eg*\u0019\u0011Q\u0006\u0006\u0002\u001d5Lg.Z2sC\u001a$hm\u001c:hK&!\u0011\u0011GA\u0014\u0005)1E.^5e'R\f7m\u001b\u0005\t\u0003k\tI\u00021\u0001\u00028\u00051Am\u001c$jY2\u00042!]A\u001d\u0013\r\tYD\u001d\u0002\b\u0005>|G.Z1o\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\nQbY1o\u0013:\u0004X\u000f\u001e$mk&$G\u0003BA\u001c\u0003\u0007B\u0001\"!\u0012\u0002>\u0001\u0007\u0011qI\u0001\u0006M2,\u0018\u000e\u001a\t\u0005\u0003K\tI%\u0003\u0003\u0002L\u0005\u001d\"!\u0002$mk&$\u0007bBA(\u0001\u0011\u0005\u0011\u0011K\u0001\fO\u0016$H+\u00198l\u0013:4w.\u0006\u0002\u0002TA)\u0011/!\u0016\u0002Z%\u0019\u0011q\u000b:\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0015\u00121L\u0005\u0005\u0003;\n9CA\u0007GYVLG\rV1oW&sgm\u001c\u0005\b\u0003C\u0002A\u0011AA2\u0003\u001d)\u0007\u0010\u001e:bGR$b!!\u001a\u0002l\u0005=\u0004cA9\u0002h%\u0019\u0011\u0011\u000e:\u0003\u000b\u0019cw.\u0019;\t\u0011\u00055\u0014q\fa\u0001\u0003K\n\u0011A\u001e\u0005\t\u0003c\ny\u00061\u0001\u00028\u0005A1/[7vY\u0006$X\r\u0003\u0004\u0002v\u0001!\tA_\u0001\u0011_:lu\u000eZ;mKN\u001c\u0005.\u00198hK\u0012\u0004")
public class TileSteamTurbineController
extends TileControllerGui
implements CIFluidInput,
CIPowerProducer {
    private final MachineSteamTurbine$ cfg;
    private final GeneratorsResourceProvider$ resources;
    private final DataSlotTank steam;
    private final DataSlotPower power;
    private final DataSlotDouble speed;
    private final DataSlotInt numTurbines;
    private final DataSlotMovingAverage outputAverage;
    private final DataSlotMovingAverage steamAverage;
    private int maxOutputs;
    private final DataSlotBlockFaceMap outputFaces;
    private final DataSlotOutputConfig outputConfig;
    private volatile boolean bitmap$0;

    private int maxOutputs$lzycompute() {
        TileSteamTurbineController tileSteamTurbineController = this;
        synchronized (tileSteamTurbineController) {
            if (!this.bitmap$0) {
                this.maxOutputs = 6;
                this.bitmap$0 = true;
            }
            return this.maxOutputs;
        }
    }

    public DataSlotBlockFaceMap outputFaces() {
        return this.outputFaces;
    }

    public DataSlotOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public /* synthetic */ void net$bdew$lib$multiblock$interact$CIOutputFaces$$super$moduleRemoved(TileModule module) {
        TileController.class.moduleRemoved((TileController)this, (TileModule)module);
    }

    public void net$bdew$lib$multiblock$interact$CIOutputFaces$_setter_$outputFaces_$eq(DataSlotBlockFaceMap x$1) {
        this.outputFaces = x$1;
    }

    public void net$bdew$lib$multiblock$interact$CIOutputFaces$_setter_$outputConfig_$eq(DataSlotOutputConfig x$1) {
        this.outputConfig = x$1;
    }

    public int newOutput(BlockRef bp, ForgeDirection face, OutputConfig cfg) {
        return CIOutputFaces.class.newOutput((CIOutputFaces)this, (BlockRef)bp, (ForgeDirection)face, (OutputConfig)cfg);
    }

    public void moduleRemoved(TileModule module) {
        CIOutputFaces.class.moduleRemoved((CIOutputFaces)this, (TileModule)module);
    }

    public void doOutputs() {
        CIOutputFaces.class.doOutputs((CIOutputFaces)this);
    }

    public void removeOutput(BlockRef bp, ForgeDirection face) {
        CIOutputFaces.class.removeOutput((CIOutputFaces)this, (BlockRef)bp, (ForgeDirection)face);
    }

    public MachineSteamTurbine$ cfg() {
        return this.cfg;
    }

    public GeneratorsResourceProvider$ resources() {
        return this.resources;
    }

    public DataSlotTank steam() {
        return this.steam;
    }

    public DataSlotPower power() {
        return this.power;
    }

    public DataSlotDouble speed() {
        return this.speed;
    }

    public DataSlotInt numTurbines() {
        return this.numTurbines;
    }

    public DataSlotMovingAverage outputAverage() {
        return this.outputAverage;
    }

    public DataSlotMovingAverage steamAverage() {
        return this.steamAverage;
    }

    public int maxOutputs() {
        return this.bitmap$0 ? this.maxOutputs : this.maxOutputs$lzycompute();
    }

    public void doUpdate() {
        if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) > 1.0 && this.power().stored() < this.power().capacity()) {
            double canGenerate = Math.min(BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) / this.cfg().effectiveRPM(), 1.0) * (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines())) * this.cfg().mjPerTickPerTurbine();
            double injected = Math.min(canGenerate, (double)(this.power().capacity() - this.power().stored()));
            this.power().stored_$eq(this.power().stored() + (float)injected);
            this.outputAverage().update(injected);
            this.speed().$minus$eq((Object)BoxesRunTime.boxToDouble((double)(this.cfg().maxRPM() * this.cfg().spinDownMultiplier() * (injected / (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines())) / this.cfg().mjPerTickPerTurbine()))));
            if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) < 1.0) {
                this.speed().$colon$eq((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            this.lastChange_$eq(this.field_145850_b.func_82737_E());
        } else {
            this.outputAverage().update(0.0);
        }
        if (this.steam().getFluidAmount() > 0) {
            double steamPerTick = this.cfg().steamPerTickPerTurbine() * (double)BoxesRunTime.unboxToInt((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.numTurbines()));
            double canUseSteam = Math.min((double)this.steam().getFluidAmount(), steamPerTick);
            this.steam().drain((int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(canUseSteam)), true);
            if (canUseSteam / steamPerTick * this.cfg().maxRPM() > BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed()))) {
                this.speed().$plus$eq((Object)BoxesRunTime.boxToDouble((double)((canUseSteam / steamPerTick * this.cfg().maxRPM() - BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed()))) * this.cfg().spinUpMultiplier())));
            }
            this.steamAverage().update(canUseSteam);
        } else {
            this.steamAverage().update(0.0);
        }
        if (BoxesRunTime.unboxToDouble((Object)DataSlotVal$.MODULE$.slot2val((DataSlotVal)this.speed())) > this.cfg().maxRPM()) {
            this.speed().$colon$eq((Object)BoxesRunTime.boxToDouble((double)this.cfg().maxRPM()));
        }
    }

    public void openGui(EntityPlayer player) {
        player.openGui((Object)Generators$.MODULE$, this.cfg().guiId(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int inputFluid(FluidStack resource2, boolean doFill) {
        return this.canInputFluid(resource2.getFluid()) ? this.steam().fill(resource2, doFill) : 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canInputFluid(Fluid fluid) {
        if (fluid == null) return false;
        String string = fluid.getName();
        String string2 = "steam";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public FluidTankInfo[] getTankInfo() {
        return (FluidTankInfo[])((Object[])new FluidTankInfo[]{this.steam().getInfo()});
    }

    public float extract(float v, boolean simulate) {
        return this.power().extract(v, simulate);
    }

    public void onModulesChanged() {
        this.power().capacity_$eq((float)(this.getNumOfModules("PowerCapacitor") * Modules$PowerCapacitor$.MODULE$.capacity() + this.cfg().internalPowerCapacity()));
        this.numTurbines().$colon$eq((Object)BoxesRunTime.boxToInteger((int)this.getNumOfModules("Turbine")));
    }

    public TileSteamTurbineController() {
        CIOutputFaces.class.$init$((CIOutputFaces)this);
        this.cfg = MachineSteamTurbine$.MODULE$;
        this.resources = GeneratorsResourceProvider$.MODULE$;
        this.steam = new DataSlotTank("steam", (TileDataSlots)this, this.cfg().internalSteamCapacity());
        this.power = new DataSlotPower("power", (TileDataSlots)this);
        this.speed = (DataSlotDouble)new DataSlotDouble("speed", (TileDataSlots)this, DataSlotDouble$.MODULE$.$lessinit$greater$default$3()).setUpdate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.GUI(), UpdateKind$.MODULE$.SAVE()}));
        this.numTurbines = (DataSlotInt)new DataSlotInt("turbines", (TileDataSlots)this, DataSlotInt$.MODULE$.$lessinit$greater$default$3()).setUpdate((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{UpdateKind$.MODULE$.GUI()}));
        this.outputAverage = new DataSlotMovingAverage("outputAverage", (TileDataSlots)this, 20);
        this.steamAverage = new DataSlotMovingAverage("steamAverage", (TileDataSlots)this, 20);
        this.serverTick().listen((Object)new Serializable(this){
            private final /* synthetic */ TileSteamTurbineController $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.doUpdate();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

