/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons;

import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.PacketHelper;
import net.bdew.neiaddons.api.SubPacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet250CustomPayload;
import org.apache.commons.lang3.StringUtils;

public class ServerHandler
implements IPacketHandler,
IPlayerTracker {
    private static Map<String, SubPacketHandler> handlers = new HashMap<String, SubPacketHandler>();

    public static void registerHandler(String command, SubPacketHandler handler) {
        if (handlers.containsKey(command)) {
            throw new RuntimeException(String.format("Tried to register handler for command %s that's already registered for %s", command, handler.toString()));
        }
        handlers.put(command, handler);
    }

    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player player) {
        EntityPlayerMP p = (EntityPlayerMP)player;
        try {
            NBTTagCompound data = CompressedStreamTools.func_74792_a((byte[])packet.field_73629_c);
            String cmd = data.func_74779_i("cmd");
            if (handlers.containsKey(cmd)) {
                NEIAddons.logInfo("Handling %s from %s -> %s", cmd, p.field_71092_bJ, handlers.get(cmd).toString());
                handlers.get(cmd).handle(data.func_74775_l("data"), p);
            } else {
                NEIAddons.logWarning("Uknown packet from client '%s': %s", p.field_71092_bJ, cmd);
            }
        }
        catch (Throwable e) {
            NEIAddons.logWarning("Error handling packet from client '%s'", p.field_71092_bJ);
            e.printStackTrace();
        }
    }

    private void sendPlayerHello(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("commands", StringUtils.join(handlers.keySet(), (char)';'));
        nbt.func_74768_a("version", 1);
        PacketHelper.sendToClient("hello", nbt, (EntityPlayerMP)player);
    }

    public void onPlayerLogin(EntityPlayer player) {
        this.sendPlayerHello(player);
    }

    public void onPlayerLogout(EntityPlayer player) {
    }

    public void onPlayerChangedDimension(EntityPlayer player) {
        this.sendPlayerHello(player);
    }

    public void onPlayerRespawn(EntityPlayer player) {
    }
}

