/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.trees;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.Loader;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.core.ItemInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.trees.TreeBreedingHandler;
import net.bdew.neiaddons.forestry.trees.TreeProduceHandler;
import net.minecraft.item.ItemStack;

public class TreeHelper {
    private static TreeBreedingHandler breedingRecipeHandler;
    private static TreeProduceHandler produceRecipeHandler;
    public static Collection<IAlleleTreeSpecies> allSpecies;
    public static Map<Integer, Collection<IAlleleSpecies>> productsCache;
    public static ITreeRoot root;

    private static void addProductToCache(int id, IAlleleTreeSpecies species) {
        if (!productsCache.containsKey(id)) {
            productsCache.put(id, new ArrayList());
        }
        productsCache.get(id).add((IAlleleSpecies)species);
    }

    public static void setup() {
        root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        allSpecies = GeneticsUtils.getAllTreeSpecies(AddonForestry.loadBlacklisted);
        if (AddonForestry.showTreeMutations) {
            breedingRecipeHandler = new TreeBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        if (AddonForestry.showTreeProducts) {
            produceRecipeHandler = new TreeProduceHandler();
            API.registerRecipeHandler((ICraftingHandler)produceRecipeHandler);
            API.registerUsageHandler((IUsageHandler)produceRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(produceRecipeHandler.getRecipeName(), produceRecipeHandler.getRecipeIdent());
        }
        productsCache = new HashMap<Integer, Collection<IAlleleSpecies>>();
        MultiItemRange fakeRange = new MultiItemRange();
        for (IAlleleTreeSpecies species : allSpecies) {
            if (AddonForestry.addSaplings && !NEIAddons.fakeItemsOn) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.SAPLING.ordinal()));
            }
            if (AddonForestry.addPollen) {
                if (NEIAddons.fakeItemsOn) {
                    ItemStack fake = NEIAddons.fakeItem.addItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.POLLEN.ordinal()));
                    Utils.safeAddNBTItem(fake);
                    fakeRange.add(fake);
                } else {
                    Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.POLLEN.ordinal()));
                }
            }
            for (ItemStack prod : GeneticsUtils.getProduceFromSpecies((IAlleleSpecies)species).keySet()) {
                TreeHelper.addProductToCache(prod.field_77993_c, species);
            }
            for (ItemStack prod : GeneticsUtils.getSpecialtyFromSpecies((IAlleleSpecies)species).keySet()) {
                TreeHelper.addProductToCache(prod.field_77993_c, species);
            }
        }
        API.addToRange((String)"Forestry.Trees.Pollen", (MultiItemRange)fakeRange);
        if (!Loader.isModLoaded((String)"NEIPlugins")) {
            MultiItemRange saplingRange = new MultiItemRange();
            saplingRange.add(ItemInterface.getItem((String)"sapling"));
            API.addToRange((String)"Forestry.Trees.Saplings", (MultiItemRange)saplingRange);
        }
        MultiItemRange pollenRange = new MultiItemRange();
        pollenRange.add(ItemInterface.getItem((String)"pollenFertile"));
        API.addToRange((String)"Forestry.Trees.Pollen", (MultiItemRange)pollenRange);
    }
}

