/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.bdew.neiaddons.BaseAddon;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.CraftingOverlayHelper;
import net.bdew.neiaddons.forestry.bees.BeeHelper;
import net.bdew.neiaddons.forestry.butterflies.ButterflyHelper;
import net.bdew.neiaddons.forestry.trees.TreeHelper;
import net.bdew.neiaddons.network.ServerHandler;
import net.bdew.neiaddons.utils.SetRecipeCommandHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;

@Mod(modid="NEIAddons|Forestry", name="NEI Addons: Forestry", version="1.12.1.7", dependencies="after:NEIAddons;after:Forestry")
public class AddonForestry
extends BaseAddon {
    public static boolean showSecret;
    public static boolean addBees;
    public static boolean addCombs;
    public static boolean addSaplings;
    public static boolean addPollen;
    public static boolean loadBlacklisted;
    public static boolean showBeeMutations;
    public static boolean showBeeProducts;
    public static boolean showTreeMutations;
    public static boolean showTreeProducts;
    public static boolean showButterflyMutations;
    public static boolean showButterflyProducts;
    public static boolean showReqs;
    public static Class<? extends GuiContainer> GuiWorktable;
    public static Class<? extends Container> ContainerWorktable;
    public static Class<? extends Slot> SlotCraftMatrix;
    public static boolean craftingActive;
    public static final String commandName = "SetForestryWorktableRecipe";
    @Mod.Instance(value="NEIAddons|Forestry")
    public static AddonForestry instance;

    @Override
    public String getName() {
        return "Forestry";
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"Forestry@[2.2.9.0,)"};
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        this.doPreInit(ev);
    }

    @Override
    public void init(Side side) throws Exception {
        showBeeMutations = NEIAddons.config.get(this.getName(), "Show Bee Mutations", true, "Set to false to disable bee mutations browsing").getBoolean(false);
        showBeeProducts = NEIAddons.config.get(this.getName(), "Show Bee Products", true, "Set to false to disable bee products browsing").getBoolean(false);
        showTreeMutations = NEIAddons.config.get(this.getName(), "Show Tree Mutations", true, "Set to false to disable tree mutations browsing").getBoolean(false);
        showTreeProducts = NEIAddons.config.get(this.getName(), "Show Tree Products", true, "Set to false to disable tree products browsing").getBoolean(false);
        showButterflyMutations = NEIAddons.config.get(this.getName(), "Show Butterfly Mutations", true, "Set to false to disable butterfly mutations browsing").getBoolean(false);
        showSecret = NEIAddons.config.get(this.getName(), "Show Secret Mutations", false, "Set to true to show secret mutations").getBoolean(false);
        showReqs = NEIAddons.config.get(this.getName(), "Show Mutation Requirements", true, "Set to false disable display of mutation requirements").getBoolean(false);
        addBees = NEIAddons.config.get(this.getName(), "Add Bees to Search", true, "Set to true to add all bees to NEI search").getBoolean(false);
        addCombs = NEIAddons.config.get(this.getName(), "Add Combs to Search", false, "Set to true to add all combs that are produced by bees to NEI search").getBoolean(false);
        addSaplings = NEIAddons.config.get(this.getName(), "Add Saplings to Search", true, "Set to true to add all saplings to NEI search").getBoolean(false);
        addPollen = NEIAddons.config.get(this.getName(), "Add Pollen to Search", true, "Set to true to add all pollen types to NEI search").getBoolean(false);
        loadBlacklisted = NEIAddons.config.get(this.getName(), "Load blacklisted", false, "Set to true to load blacklisted species and alleles, it's dangerous and (mostly) useless").getBoolean(false);
        if (this.verifyModVersion("Forestry@[2.3.0.5,)").booleanValue()) {
            try {
                if (side == Side.CLIENT) {
                    GuiWorktable = Utils.getAndCheckClass("forestry.factory.gui.GuiWorktable", GuiContainer.class);
                }
                ContainerWorktable = Utils.getAndCheckClass("forestry.factory.gui.ContainerWorktable", Container.class);
                SlotCraftMatrix = Utils.getAndCheckClass("forestry.factory.gui.SlotCraftMatrix", Slot.class);
                ServerHandler.registerHandler(commandName, new SetRecipeCommandHandler(ContainerWorktable, SlotCraftMatrix));
                craftingActive = true;
            }
            catch (Throwable e) {
                instance.logWarningExc(e, "Failed to setup Worktable crafting overlay", new Object[0]);
            }
        } else {
            this.logInfo("Forestry Worktable support not loaded", new Object[0]);
        }
        this.active = true;
    }

    public void registerWithNEIPlugins(String name, String id) {
        FMLInterModComms.sendRuntimeMessage((Object)this, (String)"NEIPlugins", (String)"register-crafting-handler", (String)String.format("Forestry Genetics@%s@%s", name, id));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void loadClient() {
        BeeHelper.setup();
        TreeHelper.setup();
        ButterflyHelper.setup();
        if (craftingActive) {
            CraftingOverlayHelper.setup();
        }
    }

    static {
        craftingActive = false;
    }
}

