/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.bees;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.bees.BeeBreedingHandler;
import net.bdew.neiaddons.forestry.bees.BeeProduceHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BeeHelper {
    public static Collection<IAlleleBeeSpecies> allSpecies;
    public static Map<Item, Collection<IAlleleSpecies>> productsCache;
    public static IBeeRoot root;

    private static void addProductToCache(Item item, IAlleleBeeSpecies species) {
        if (!productsCache.containsKey(item)) {
            productsCache.put(item, new ArrayList());
        }
        productsCache.get(item).add(species);
    }

    private static void addHandlers() {
        if (AddonForestry.showBeeMutations) {
            BeeBreedingHandler breedingRecipeHandler = new BeeBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        if (AddonForestry.showBeeProducts) {
            BeeProduceHandler productsRecipeHandler = new BeeProduceHandler();
            API.registerRecipeHandler((ICraftingHandler)productsRecipeHandler);
            API.registerUsageHandler((IUsageHandler)productsRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(productsRecipeHandler.getRecipeName(), productsRecipeHandler.getRecipeIdent());
        }
    }

    public static void setup() {
        root = (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        allSpecies = GeneticsUtils.getAllBeeSpecies(AddonForestry.loadBlacklisted);
        BeeHelper.addHandlers();
        HashMap seencombs = new HashMap();
        List<Item> modCombs = BeeHelper.getMobCombs();
        for (Item combItem : modCombs) {
            seencombs.put(combItem, new HashSet());
        }
        for (IAlleleBeeSpecies species : allSpecies) {
            if (AddonForestry.addBees) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.QUEEN.ordinal()));
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.DRONE.ordinal()));
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumBeeType.PRINCESS.ordinal()));
            }
            for (ItemStack prod : GeneticsUtils.getProduceFromSpecies(species).keySet()) {
                BeeHelper.addProductToCache(prod.func_77973_b(), species);
                if (!AddonForestry.addCombs || !seencombs.containsKey(prod.func_77973_b())) continue;
                ((HashSet)seencombs.get(prod.func_77973_b())).add(prod.func_77960_j());
            }
            for (ItemStack prod : GeneticsUtils.getSpecialtyFromSpecies(species).keySet()) {
                BeeHelper.addProductToCache(prod.func_77973_b(), species);
                if (!AddonForestry.addCombs || !seencombs.containsKey(prod.func_77973_b())) continue;
                ((HashSet)seencombs.get(prod.func_77973_b())).add(prod.func_77960_j());
            }
        }
        if (AddonForestry.addCombs) {
            for (Item combItem : modCombs) {
                HashSet subitems = (HashSet)seencombs.get(combItem);
                ArrayList combs = new ArrayList();
                combItem.func_150895_a(combItem, null, combs);
                for (ItemStack item : combs) {
                    subitems.add(item.func_77960_j());
                    AddonForestry.instance.logInfo("Registering comb variant for %s: %s", combItem.getClass().getName(), item.toString());
                    API.addItemListEntry((ItemStack)item);
                }
            }
        }
    }

    private static List<Item> getMobCombs() {
        ArrayList<Item> res = new ArrayList<Item>();
        Item vanillaComb = GameRegistry.findItem((String)"Forestry", (String)"beeCombs");
        if (vanillaComb == null) {
            AddonForestry.instance.logWarning("Failed to get forestry bee comb item, something is messed up", new Object[0]);
        } else {
            res.add(vanillaComb);
        }
        if (Loader.isModLoaded((String)"ExtraBees")) {
            try {
                Class<?> ebItems = Class.forName("binnie.extrabees.ExtraBees");
                Object ebComb = ebItems.getField("comb").get(null);
                if (ebComb instanceof Item) {
                    AddonForestry.instance.logInfo("Loaded Extra Bees comb item: %s (%d)", ebComb.toString(), ebComb);
                    res.add((Item)ebComb);
                } else {
                    AddonForestry.instance.logWarning("Extra Bees comb is not Item subclass!", new Object[0]);
                }
            }
            catch (Throwable e) {
                AddonForestry.instance.logWarningExc(e, "Error locating Extra Bees comb item", new Object[0]);
            }
        }
        if (Loader.isModLoaded((String)"MagicBees")) {
            try {
                Class<?> mbConfig = Class.forName("magicbees.main.Config");
                Object mbComb = mbConfig.getField("combs").get(null);
                AddonForestry.instance.logInfo("Loaded TB comb item: %s", mbComb.toString());
                if (mbComb instanceof Item) {
                    AddonForestry.instance.logInfo("Loaded Magic Bees comb item: %s (%d)", mbComb.toString(), mbComb);
                    res.add((Item)mbComb);
                } else {
                    AddonForestry.instance.logWarning("Magic Bees comb is not Item subclass!", new Object[0]);
                }
            }
            catch (Throwable e) {
                AddonForestry.instance.logWarningExc(e, "Error locating Magic Bees comb item", new Object[0]);
            }
        }
        return res;
    }

    static {
        productsCache = new HashMap<Item, Collection<IAlleleSpecies>>();
    }
}

