/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry.trees;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.Utils;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.trees.TreeBreedingHandler;
import net.bdew.neiaddons.forestry.trees.TreeProduceHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class TreeHelper {
    public static Collection<IAlleleTreeSpecies> allSpecies;
    public static Map<Item, Collection<IAlleleSpecies>> productsCache;
    public static ITreeRoot root;

    private static void addProductToCache(Item item, IAlleleTreeSpecies species) {
        if (!productsCache.containsKey(item)) {
            productsCache.put(item, new ArrayList());
        }
        productsCache.get(item).add(species);
    }

    public static void setup() {
        root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
        allSpecies = GeneticsUtils.getAllTreeSpecies(AddonForestry.loadBlacklisted);
        if (AddonForestry.showTreeMutations) {
            TreeBreedingHandler breedingRecipeHandler = new TreeBreedingHandler();
            API.registerRecipeHandler((ICraftingHandler)breedingRecipeHandler);
            API.registerUsageHandler((IUsageHandler)breedingRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(breedingRecipeHandler.getRecipeName(), breedingRecipeHandler.getRecipeIdent());
        }
        if (AddonForestry.showTreeProducts) {
            TreeProduceHandler produceRecipeHandler = new TreeProduceHandler();
            API.registerRecipeHandler((ICraftingHandler)produceRecipeHandler);
            API.registerUsageHandler((IUsageHandler)produceRecipeHandler);
            AddonForestry.instance.registerWithNEIPlugins(produceRecipeHandler.getRecipeName(), produceRecipeHandler.getRecipeIdent());
        }
        for (IAlleleTreeSpecies species : allSpecies) {
            if (AddonForestry.addSaplings) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.SAPLING.ordinal()));
            }
            if (AddonForestry.addPollen) {
                Utils.safeAddNBTItem(GeneticsUtils.stackFromSpecies((IAlleleSpecies)species, EnumGermlingType.POLLEN.ordinal()));
            }
            for (ItemStack prod : GeneticsUtils.getProduceFromSpecies(species).keySet()) {
                TreeHelper.addProductToCache(prod.func_77973_b(), species);
            }
            for (ItemStack prod : GeneticsUtils.getSpecialtyFromSpecies(species).keySet()) {
                TreeHelper.addProductToCache(prod.func_77973_b(), species);
            }
        }
    }

    static {
        productsCache = new HashMap<Item, Collection<IAlleleSpecies>>();
    }
}

