/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.pressure.pressurenet;

import net.bdew.lib.block.BlockRef;
import net.bdew.pressure.Pressure$;
import net.bdew.pressure.api.IFilterable;
import net.bdew.pressure.api.IFilterableProvider;
import net.bdew.pressure.api.IPressureConnection;
import net.bdew.pressure.api.IPressureEject;
import net.bdew.pressure.api.IPressureExtension;
import net.bdew.pressure.api.IPressureHelper;
import net.bdew.pressure.api.IPressureInject;
import net.bdew.pressure.pressurenet.BlockRefFace;
import net.bdew.pressure.pressurenet.BlockRefFace$;
import net.bdew.pressure.pressurenet.Helper$;
import net.bdew.pressure.pressurenet.InternalPressureExtension$;
import net.bdew.pressure.pressurenet.PressureConnection;
import net.bdew.pressure.pressurenet.PressureInputFace;
import net.bdew.pressure.pressurenet.PressureOutputFace;
import net.bdew.pressure.pressurenet.ScanResult;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.util.DynamicVariable;

public final class Helper$
implements IPressureHelper {
    public static final Helper$ MODULE$;
    private List<IPressureExtension> extensions;
    private List<IFilterableProvider> filterable;
    private final DynamicVariable<scala.collection.immutable.Set<IPressureConnection>> recursionGuard;

    static {
        new Helper$();
    }

    public List<IPressureExtension> extensions() {
        return this.extensions;
    }

    public void extensions_$eq(List<IPressureExtension> x$1) {
        this.extensions = x$1;
    }

    public List<IFilterableProvider> filterable() {
        return this.filterable;
    }

    public void filterable_$eq(List<IFilterableProvider> x$1) {
        this.filterable = x$1;
    }

    public DynamicVariable<scala.collection.immutable.Set<IPressureConnection>> recursionGuard() {
        return this.recursionGuard;
    }

    public ScanResult scanConnectedBlocks(IBlockAccess w, BlockRef start, ForgeDirection face, boolean forceNeighbours) {
        Set seen = Set$.MODULE$.empty();
        Queue queue = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockRefFace[]{new BlockRefFace(start, face)}));
        if (forceNeighbours) {
            start.neighbours().withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<ForgeDirection, BlockRef> check$ifrefutable$1) {
                    Tuple2<ForgeDirection, BlockRef> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(queue){
                private final Queue queue$1;

                public final void apply(Tuple2<ForgeDirection, BlockRef> x$1) {
                    Tuple2<ForgeDirection, BlockRef> tuple2 = x$1;
                    if (tuple2 != null) {
                        ForgeDirection face = (ForgeDirection)tuple2._1();
                        BlockRef block = (BlockRef)tuple2._2();
                        this.queue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockRefFace[]{new BlockRefFace(block, face.getOpposite())}));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.queue$1 = queue$1;
                }
            });
        } else {
            ForgeDirection forgeDirection = face;
            ForgeDirection forgeDirection2 = ForgeDirection.UNKNOWN;
            if ((forgeDirection == null ? forgeDirection2 != null : !forgeDirection.equals(forgeDirection2)) && this.isConnectableBlock(w, start.neighbour(face))) {
                queue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockRefFace[]{new BlockRefFace(start.neighbour(face), face.getOpposite())}));
            }
        }
        Set inputs = Set$.MODULE$.empty();
        Set outputs = Set$.MODULE$.empty();
        while (queue.nonEmpty()) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BlockRefFace current = (BlockRefFace)queue.dequeue();
            if (this.isTraversableBlock(w, BlockRefFace$.MODULE$.brf2br(current))) {
                seen.add((Object)current.block());
                boxedUnit2 = queue.$plus$plus$eq((TraversableOnce)((TraversableLike)this.getPipeConnections(w, BlockRefFace$.MODULE$.brf2br(current)).map((Function1)new Serializable(current){
                    private final BlockRefFace current$1;

                    public final BlockRefFace apply(ForgeDirection x) {
                        return new BlockRefFace(BlockRefFace$.MODULE$.brf2br(this.current$1).neighbour(x), x.getOpposite());
                    }
                    {
                        this.current$1 = current$1;
                    }
                }, List$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(seen){
                    private final Set seen$1;

                    public final boolean apply(BlockRefFace x) {
                        return this.seen$1.contains((Object)x.block());
                    }
                    {
                        this.seen$1 = seen$1;
                    }
                }));
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            ForgeDirection forgeDirection = current.face();
            ForgeDirection forgeDirection3 = ForgeDirection.UNKNOWN;
            if ((forgeDirection == null ? forgeDirection3 != null : !forgeDirection.equals(forgeDirection3)) && this.canPipeConnectTo(w, BlockRefFace$.MODULE$.brf2br(current), current.face())) {
                TileEntity tile = (TileEntity)BlockRefFace$.MODULE$.brf2br(current).tile(w).orNull(Predef$.MODULE$.$conforms());
                Object object = tile instanceof IPressureInject ? inputs.$plus$eq((Object)new PressureInputFace((IPressureInject)tile, current.face())) : BoxedUnit.UNIT;
                if (tile instanceof IPressureEject) {
                    boxedUnit = outputs.$plus$eq((Object)new PressureOutputFace((IPressureEject)tile, current.face()));
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return new ScanResult((scala.collection.immutable.Set<PressureInputFace>)inputs.toSet(), (scala.collection.immutable.Set<PressureOutputFace>)outputs.toSet(), (scala.collection.immutable.Set<BlockRef>)seen.toSet());
    }

    @Override
    public void notifyBlockChanged(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.scanConnectedBlocks((IBlockAccess)world, new BlockRef(x, y, z), ForgeDirection.UNKNOWN, true).inputs().foreach((Function1)new Serializable(){

                public final void apply(PressureInputFace x$2) {
                    x$2.invalidateConnection();
                }
            });
        }
    }

    @Override
    public IPressureConnection recalculateConnectionInfo(IPressureInject te, ForgeDirection side) {
        PressureConnection pressureConnection;
        if (te.getWorld().field_72995_K) {
            Pressure$.MODULE$.logWarn("Attempt to generate ConnectionInfo on client side from %s. This is a bug.", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{te}));
            pressureConnection = null;
        } else {
            pressureConnection = new PressureConnection(te, side, this.scanConnectedBlocks((IBlockAccess)te.getWorld(), new BlockRef(te.getXCoord(), te.getYCoord(), te.getZCoord()), side, false).outputs());
        }
        return pressureConnection;
    }

    public List<ForgeDirection> getPipeConnections(IBlockAccess w, BlockRef ref) {
        return ((TraversableOnce)ref.neighbours().withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<ForgeDirection, BlockRef> check$ifrefutable$2) {
                Tuple2<ForgeDirection, BlockRef> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(w, ref){
            private final IBlockAccess w$2;
            private final BlockRef ref$1;

            public final boolean apply(Tuple2<ForgeDirection, BlockRef> x$3) {
                Tuple2<ForgeDirection, BlockRef> tuple2 = x$3;
                if (tuple2 != null) {
                    ForgeDirection dir = (ForgeDirection)tuple2._1();
                    BlockRef target = (BlockRef)tuple2._2();
                    boolean bl = Helper$.MODULE$.canPipeConnectFrom(this.w$2, this.ref$1, dir) && Helper$.MODULE$.canPipeConnectTo(this.w$2, target, dir.getOpposite());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.w$2 = w$2;
                this.ref$1 = ref$1;
            }
        }).map((Function1)new Serializable(){

            public final ForgeDirection apply(Tuple2<ForgeDirection, BlockRef> x$4) {
                Tuple2<ForgeDirection, BlockRef> tuple2 = x$4;
                if (tuple2 != null) {
                    ForgeDirection dir;
                    ForgeDirection forgeDirection = dir = (ForgeDirection)tuple2._1();
                    return forgeDirection;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
    }

    public List<ForgeDirection> getPipeConnections(IBlockAccess w, int x, int y, int z) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).toList().filter((Function1)new Serializable(w, x, y, z){
            private final IBlockAccess w$1;
            private final int x$15;
            private final int y$1;
            private final int z$1;

            public final boolean apply(ForgeDirection dir) {
                return this.y$1 + dir.offsetY >= 0 && this.y$1 + dir.offsetY < 256 && Helper$.MODULE$.canPipeConnectFrom(this.w$1, this.x$15, this.y$1, this.z$1, dir) && Helper$.MODULE$.canPipeConnectTo(this.w$1, this.x$15 + dir.offsetX, this.y$1 + dir.offsetY, this.z$1 + dir.offsetZ, dir.getOpposite());
            }
            {
                this.w$1 = w$1;
                this.x$15 = x$15;
                this.y$1 = y$1;
                this.z$1 = z$1;
            }
        });
    }

    @Override
    public boolean canPipeConnectTo(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z, side){
            private final IBlockAccess w$5;
            private final int x$17;
            private final int y$3;
            private final int z$3;
            private final ForgeDirection side$2;

            public final boolean apply(IPressureExtension x$5) {
                return x$5.canPipeConnectTo(this.w$5, this.x$17, this.y$3, this.z$3, this.side$2);
            }
            {
                this.w$5 = w$5;
                this.x$17 = x$17;
                this.y$3 = y$3;
                this.z$3 = z$3;
                this.side$2 = side$2;
            }
        });
    }

    @Override
    public boolean canPipeConnectFrom(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z, side){
            private final IBlockAccess w$11;
            private final int x$20;
            private final int y$6;
            private final int z$6;
            private final ForgeDirection side$4;

            public final boolean apply(IPressureExtension x$6) {
                return x$6.canPipeConnectFrom(this.w$11, this.x$20, this.y$6, this.z$6, this.side$4);
            }
            {
                this.w$11 = w$11;
                this.x$20 = x$20;
                this.y$6 = y$6;
                this.z$6 = z$6;
                this.side$4 = side$4;
            }
        });
    }

    @Override
    public boolean isConnectableBlock(IBlockAccess w, int x, int y, int z) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z){
            private final IBlockAccess w$7;
            private final int x$18;
            private final int y$4;
            private final int z$4;

            public final boolean apply(IPressureExtension x$7) {
                return x$7.isConnectableBlock(this.w$7, this.x$18, this.y$4, this.z$4);
            }
            {
                this.w$7 = w$7;
                this.x$18 = x$18;
                this.y$4 = y$4;
                this.z$4 = z$4;
            }
        });
    }

    @Override
    public boolean isTraversableBlock(IBlockAccess w, int x, int y, int z) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z){
            private final IBlockAccess w$9;
            private final int x$19;
            private final int y$5;
            private final int z$5;

            public final boolean apply(IPressureExtension x$8) {
                return x$8.isTraversableBlock(this.w$9, this.x$19, this.y$5, this.z$5);
            }
            {
                this.w$9 = w$9;
                this.x$19 = x$19;
                this.y$5 = y$5;
                this.z$5 = z$5;
            }
        });
    }

    public boolean canPipeConnectTo(IBlockAccess w, BlockRef ref, ForgeDirection side) {
        return this.extensions().exists((Function1)new Serializable(w, ref, side){
            private final IBlockAccess w$4;
            private final BlockRef ref$2;
            private final ForgeDirection side$1;

            public final boolean apply(IPressureExtension x$9) {
                return x$9.canPipeConnectTo(this.w$4, this.ref$2.x(), this.ref$2.y(), this.ref$2.z(), this.side$1);
            }
            {
                this.w$4 = w$4;
                this.ref$2 = ref$2;
                this.side$1 = side$1;
            }
        });
    }

    public boolean canPipeConnectFrom(IBlockAccess w, BlockRef ref, ForgeDirection side) {
        return this.extensions().exists((Function1)new Serializable(w, ref, side){
            private final IBlockAccess w$10;
            private final BlockRef ref$5;
            private final ForgeDirection side$3;

            public final boolean apply(IPressureExtension x$10) {
                return x$10.canPipeConnectFrom(this.w$10, this.ref$5.x(), this.ref$5.y(), this.ref$5.z(), this.side$3);
            }
            {
                this.w$10 = w$10;
                this.ref$5 = ref$5;
                this.side$3 = side$3;
            }
        });
    }

    public boolean isConnectableBlock(IBlockAccess w, BlockRef ref) {
        return this.extensions().exists((Function1)new Serializable(w, ref){
            private final IBlockAccess w$6;
            private final BlockRef ref$3;

            public final boolean apply(IPressureExtension x$11) {
                return x$11.isConnectableBlock(this.w$6, this.ref$3.x(), this.ref$3.y(), this.ref$3.z());
            }
            {
                this.w$6 = w$6;
                this.ref$3 = ref$3;
            }
        });
    }

    public boolean isTraversableBlock(IBlockAccess w, BlockRef ref) {
        return this.extensions().exists((Function1)new Serializable(w, ref){
            private final IBlockAccess w$8;
            private final BlockRef ref$4;

            public final boolean apply(IPressureExtension x$12) {
                return x$12.isTraversableBlock(this.w$8, this.ref$4.x(), this.ref$4.y(), this.ref$4.z());
            }
            {
                this.w$8 = w$8;
                this.ref$4 = ref$4;
            }
        });
    }

    @Override
    public boolean tryPlaceBlock(World w, int x, int y, int z, Block b, EntityPlayerMP p) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z, b, p){
            private final World w$3;
            private final int x$16;
            private final int y$2;
            private final int z$2;
            private final Block b$1;
            private final EntityPlayerMP p$1;

            public final boolean apply(IPressureExtension x$13) {
                return x$13.tryPlaceBlock(this.w$3, this.x$16, this.y$2, this.z$2, this.b$1, this.p$1);
            }
            {
                this.w$3 = w$3;
                this.x$16 = x$16;
                this.y$2 = y$2;
                this.z$2 = z$2;
                this.b$1 = b$1;
                this.p$1 = p$1;
            }
        });
    }

    public IFilterable getFilterableForWorldCoordinates(World world, int x, int y, int z, int side) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            IFilterable iFilterable;
            Object object = new Object();
            try {
                this.filterable().foreach((Function1)new Serializable(world, x, y, z, side, object){
                    private final World world$1;
                    private final int x$21;
                    private final int y$7;
                    private final int z$7;
                    private final int side$5;
                    public final Object nonLocalReturnKey1$1;

                    public final Option<Nothing$> apply(IFilterableProvider fp) {
                        return Option$.MODULE$.apply((Object)fp.getFilterableForWorldCoordinates(this.world$1, this.x$21, this.y$7, this.z$7, this.side$5)).map((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.getFilterableForWorldCoordinates.1 $outer;

                            public final Nothing$ apply(IFilterable x$14) {
                                throw new NonLocalReturnControl(this.$outer.nonLocalReturnKey1$1, (Object)x$14);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.world$1 = world$1;
                        this.x$21 = x$21;
                        this.y$7 = y$7;
                        this.z$7 = z$7;
                        this.side$5 = side$5;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                iFilterable = null;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                iFilterable = (IFilterable)nonLocalReturnControl2.value();
            }
            return iFilterable;
        }
        throw nonLocalReturnControl2;
    }

    @Override
    public void registerExtension(IPressureExtension ext) {
        this.extensions_$eq((List<IPressureExtension>)((List)this.extensions().$colon$plus((Object)ext, List$.MODULE$.canBuildFrom())));
    }

    @Override
    public void registerIFilterableProvider(IFilterableProvider provider) {
        this.filterable_$eq((List<IFilterableProvider>)((List)this.filterable().$colon$plus((Object)provider, List$.MODULE$.canBuildFrom())));
    }

    private Helper$() {
        MODULE$ = this;
        this.extensions = List$.MODULE$.empty();
        this.filterable = List$.MODULE$.empty();
        this.registerExtension(InternalPressureExtension$.MODULE$);
        this.registerIFilterableProvider(InternalPressureExtension$.MODULE$);
        this.recursionGuard = new DynamicVariable((Object)Predef$.MODULE$.Set().empty());
    }
}

