/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.pressure.misc;

import net.bdew.pressure.Pressure$;
import net.bdew.pressure.api.IConnectionInfo;
import net.bdew.pressure.api.IPressureConnectableBlock;
import net.bdew.pressure.api.IPressureEject;
import net.bdew.pressure.api.IPressureExtension;
import net.bdew.pressure.api.IPressureHelper;
import net.bdew.pressure.api.IPressureInject;
import net.bdew.pressure.misc.BlockRef;
import net.bdew.pressure.misc.BlockRef$;
import net.bdew.pressure.misc.ConnectionInfo;
import net.bdew.pressure.misc.Helper$;
import net.bdew.pressure.misc.Helper$$anonfun$scanConnectedBlocks$1$;
import net.bdew.pressure.misc.InternalPressureExtension$;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichFloat$;

public final class Helper$
implements IPressureHelper {
    public static final Helper$ MODULE$;
    private List<IPressureExtension> extensions;
    private final ThreadLocal<scala.collection.immutable.Set<ConnectionInfo>> recursionGuard;

    static {
        new Helper$();
    }

    public List<IPressureExtension> extensions() {
        return this.extensions;
    }

    public void extensions_$eq(List<IPressureExtension> x$1) {
        this.extensions = x$1;
    }

    public ThreadLocal<scala.collection.immutable.Set<ConnectionInfo>> recursionGuard() {
        return this.recursionGuard;
    }

    public Tuple3<scala.collection.immutable.Set<IPressureInject>, scala.collection.immutable.Set<IPressureEject>, Set<BlockRef>> scanConnectedBlocks(BlockRef start, boolean forceNeighbours) {
        Set seen = scala.collection.mutable.Set$.MODULE$.empty();
        Queue queue = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockRef[]{start}));
        if (forceNeighbours) {
            queue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])start.neighbours()).map((Function1)new Serializable(){

                public final BlockRef apply(Tuple2<ForgeDirection, BlockRef> x$5) {
                    return (BlockRef)x$5._2();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockRef.class)))));
        }
        Set inputs = scala.collection.mutable.Set$.MODULE$.empty();
        Set outputs = scala.collection.mutable.Set$.MODULE$.empty();
        while (queue.nonEmpty()) {
            BlockRef current = (BlockRef)queue.dequeue();
            seen.add((Object)current);
            if (this.isConnectableBlock(current)) {
                queue.enqueue((Seq)((TraversableLike)this.getPipeConnections(current).map((Function1)new Serializable(current){
                    private final BlockRef current$1;

                    public final BlockRef apply(ForgeDirection side) {
                        return this.current$1.neighbour(side);
                    }
                    {
                        this.current$1 = current$1;
                    }
                }, List$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(seen){
                    private final Set seen$1;

                    public final boolean apply(BlockRef elem) {
                        return this.seen$1.contains((Object)elem);
                    }
                    {
                        this.seen$1 = seen$1;
                    }
                }));
            }
            current.tile().collect((PartialFunction)new Serializable(seen, queue, inputs, outputs, current){
                public final Set seen$1;
                private final Queue queue$1;
                private final Set inputs$1;
                private final Set outputs$1;
                public final BlockRef current$1;

                public final <A1 extends TileEntity, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof IPressureInject) {
                        A1 A12 = A1;
                        this.inputs$1.add(A12);
                        this.queue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).filter((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.scanConnectedBlocks.1 $outer;

                            public final boolean apply(ForgeDirection dir) {
                                return this.$outer.current$1.getBlock(ClassTag$.MODULE$.apply(IPressureConnectableBlock.class)).exists((Function1)new Serializable(this, dir){
                                    private final /* synthetic */ anonfun$scanConnectedBlocks$1$$anonfun$applyOrElse$1 $outer;
                                    private final ForgeDirection dir$1;

                                    public final boolean apply(IPressureConnectableBlock x$6) {
                                        return x$6.canConnectTo((IBlockAccess)this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.world().get(), this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.x(), this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.y(), this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.z(), this.dir$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.dir$1 = dir$1;
                                    }
                                });
                            }

                            public /* synthetic */ anonfun.scanConnectedBlocks.1 net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).map((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.scanConnectedBlocks.1 $outer;

                            public final BlockRef apply(ForgeDirection side) {
                                return this.$outer.current$1.neighbour(side);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockRef.class)))).filterNot((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.scanConnectedBlocks.1 $outer;

                            public final boolean apply(BlockRef elem) {
                                return this.$outer.seen$1.contains((Object)elem);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof IPressureEject) {
                        A1 A13 = A1;
                        this.outputs$1.add(A13);
                        this.queue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).filter((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.scanConnectedBlocks.1 $outer;

                            public final boolean apply(ForgeDirection dir) {
                                return this.$outer.current$1.getBlock(ClassTag$.MODULE$.apply(IPressureConnectableBlock.class)).exists((Function1)new Serializable(this, dir){
                                    private final /* synthetic */ anonfun$scanConnectedBlocks$1$$anonfun$applyOrElse$4 $outer;
                                    private final ForgeDirection dir$2;

                                    public final boolean apply(IPressureConnectableBlock x$7) {
                                        return x$7.canConnectTo((IBlockAccess)this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.world().get(), this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.x(), this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.y(), this.$outer.net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer().current$1.z(), this.dir$2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.dir$2 = dir$2;
                                    }
                                });
                            }

                            public /* synthetic */ anonfun.scanConnectedBlocks.1 net$bdew$pressure$misc$Helper$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })).map((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.scanConnectedBlocks.1 $outer;

                            public final BlockRef apply(ForgeDirection side) {
                                return this.$outer.current$1.neighbour(side);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockRef.class)))).filterNot((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.scanConnectedBlocks.1 $outer;

                            public final boolean apply(BlockRef elem) {
                                return this.$outer.seen$1.contains((Object)elem);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        })));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(TileEntity x1) {
                    TileEntity tileEntity = x1;
                    boolean bl = tileEntity instanceof IPressureInject ? true : tileEntity instanceof IPressureEject;
                    return bl;
                }
                {
                    this.seen$1 = seen$1;
                    this.queue$1 = queue$1;
                    this.inputs$1 = inputs$1;
                    this.outputs$1 = outputs$1;
                    this.current$1 = current$1;
                }
            });
        }
        return new Tuple3((Object)inputs.toSet(), (Object)outputs.toSet(), (Object)seen);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int pushFluidIntoPressureSytem(IConnectionInfo connection, FluidStack fluid, boolean doPush) {
        int n;
        Object object = new Object();
        try {
            block11: {
                scala.collection.immutable.Set<ConnectionInfo> recGuard;
                ConnectionInfo conn;
                block10: {
                    if (connection == null || fluid == null || fluid.getFluid() == null || fluid.amount == 0 || !(connection instanceof ConnectionInfo)) return 0;
                    conn = (ConnectionInfo)connection;
                    recGuard = this.recursionGuard().get();
                    if (recGuard.contains((Object)conn)) {
                        Pressure$.MODULE$.logInfo("Detected loop, blowing up %d,%d,%d (dim %d)", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)conn.origin().getXCoord()), BoxesRunTime.boxToInteger((int)conn.origin().getYCoord()), BoxesRunTime.boxToInteger((int)conn.origin().getZCoord()), BoxesRunTime.boxToInteger((int)conn.origin().getWorld().field_73011_w.field_76574_g)}));
                        conn.origin().getWorld().func_72876_a(null, (double)conn.origin().getXCoord(), (double)conn.origin().getYCoord(), (double)conn.origin().getZCoord(), 1.0f, true);
                        return 0;
                    }
                    this.recursionGuard().set((scala.collection.immutable.Set<ConnectionInfo>)recGuard.$plus((Object)conn));
                    if (conn.tiles().size() != 0) break block10;
                    this.recursionGuard().set(recGuard);
                    return 0;
                }
                if (fluid.amount < 10) {
                    IntRef toPush = IntRef.create((int)fluid.amount);
                    conn.tiles().foreach((Function1)new Serializable(fluid, doPush, toPush, object){
                        private final FluidStack fluid$1;
                        private final boolean doPush$1;
                        private final IntRef toPush$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(IPressureEject target) {
                            this.toPush$1.elem -= target.eject(new FluidStack(this.fluid$1.getFluid(), this.toPush$1.elem), this.doPush$1);
                            if (this.toPush$1.elem <= 0) {
                                throw new NonLocalReturnControl.mcI.sp(this.nonLocalReturnKey1$1, this.fluid$1.amount);
                            }
                        }
                        {
                            this.fluid$1 = fluid$1;
                            this.doPush$1 = doPush$1;
                            this.toPush$1 = toPush$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    n = toPush.elem - fluid.amount;
                } else {
                    Map maxFill = ((TraversableOnce)conn.tiles().map((Function1)new Serializable(fluid){
                        private final FluidStack fluid$1;

                        public final Tuple2<IPressureEject, Object> apply(IPressureEject target) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)target), (Object)BoxesRunTime.boxToInteger((int)target.eject(this.fluid$1.copy(), false)));
                        }
                        {
                            this.fluid$1 = fluid$1;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    int totalFill = BoxesRunTime.unboxToInt((Object)maxFill.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    if (!doPush) break block11;
                    float mul = totalFill > fluid.amount ? (float)fluid.amount / (float)totalFill : 1.0f;
                    n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)maxFill.map((Function1)new Serializable(fluid, mul){
                        private final FluidStack fluid$1;
                        private final float mul$1;

                        public final int apply(Tuple2<IPressureEject, Object> x0$1) {
                            Tuple2<IPressureEject, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                IPressureEject te = (IPressureEject)tuple2._1();
                                int amount = tuple2._2$mcI$sp();
                                int toFill = RichFloat$.MODULE$.round$extension(Predef$.MODULE$.floatWrapper((float)amount * this.mul$1));
                                int n = toFill > 0 ? te.eject(new FluidStack(this.fluid$1.getFluid(), toFill), true) : 0;
                                return n;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.fluid$1 = fluid$1;
                            this.mul$1 = mul$1;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                }
                this.recursionGuard().set(recGuard);
                return n;
            }
            try {
                void var11_9;
                return (int)var11_9;
            }
            finally {
                void var7_6;
                this.recursionGuard().set((scala.collection.immutable.Set<ConnectionInfo>)var7_6);
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl22) {
            if (nonLocalReturnControl22.key() != object) throw nonLocalReturnControl22;
            n = nonLocalReturnControl22.value$mcI$sp();
        }
        return n;
    }

    @Override
    public void notifyBlockChanged(World world, int x, int y, int z) {
        ((IterableLike)this.scanConnectedBlocks(BlockRef$.MODULE$.apply(world, x, y, z), true)._1()).foreach((Function1)new Serializable(){

            public final void apply(IPressureInject x$8) {
                x$8.invalidateConnection();
            }
        });
    }

    @Override
    public ConnectionInfo recalculateConnectionInfo(IPressureInject te, ForgeDirection side) {
        return new ConnectionInfo(te, side, (scala.collection.immutable.Set<IPressureEject>)((scala.collection.immutable.Set)this.scanConnectedBlocks(BlockRef$.MODULE$.apply(te.getWorld(), te.getXCoord(), te.getYCoord(), te.getZCoord()), false)._2()));
    }

    public List<ForgeDirection> getPipeConnections(BlockRef ref) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ref.neighbours()).withFilter((Function1)new Serializable(){

            public final boolean apply(Tuple2<ForgeDirection, BlockRef> check$ifrefutable$1) {
                Tuple2<ForgeDirection, BlockRef> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(ref){
            private final BlockRef ref$2;

            public final boolean apply(Tuple2<ForgeDirection, BlockRef> x$9) {
                Tuple2<ForgeDirection, BlockRef> tuple2 = x$9;
                if (tuple2 != null) {
                    ForgeDirection dir = (ForgeDirection)tuple2._1();
                    BlockRef target = (BlockRef)tuple2._2();
                    boolean bl = Helper$.MODULE$.canPipeConnectFrom(this.ref$2, dir) && Helper$.MODULE$.canPipeConnectTo(target, dir.getOpposite());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.ref$2 = ref$2;
            }
        }).map((Function1)new Serializable(){

            public final ForgeDirection apply(Tuple2<ForgeDirection, BlockRef> x$10) {
                Tuple2<ForgeDirection, BlockRef> tuple2 = x$10;
                if (tuple2 != null) {
                    ForgeDirection dir;
                    ForgeDirection forgeDirection = dir = (ForgeDirection)tuple2._1();
                    return forgeDirection;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ForgeDirection.class)))).toList();
    }

    public List<ForgeDirection> getPipeConnections(IBlockAccess w, int x, int y, int z) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])ForgeDirection.VALID_DIRECTIONS).toList().filter((Function1)new Serializable(w, x, y, z){
            private final IBlockAccess w$2;
            private final int x$19;
            private final int y$2;
            private final int z$2;

            public final boolean apply(ForgeDirection dir) {
                return Helper$.MODULE$.canPipeConnectFrom(this.w$2, this.x$19, this.y$2, this.z$2, dir) && Helper$.MODULE$.canPipeConnectTo(this.w$2, this.x$19 + dir.offsetX, this.y$2 + dir.offsetY, this.z$2 + dir.offsetZ, dir.getOpposite());
            }
            {
                this.w$2 = w$2;
                this.x$19 = x$19;
                this.y$2 = y$2;
                this.z$2 = z$2;
            }
        });
    }

    @Override
    public boolean canPipeConnectTo(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z, side){
            private final IBlockAccess w$4;
            private final int x$21;
            private final int y$4;
            private final int z$4;
            private final ForgeDirection side$2;

            public final boolean apply(IPressureExtension x$11) {
                return x$11.canPipeConnectTo(this.w$4, this.x$21, this.y$4, this.z$4, this.side$2);
            }
            {
                this.w$4 = w$4;
                this.x$21 = x$21;
                this.y$4 = y$4;
                this.z$4 = z$4;
                this.side$2 = side$2;
            }
        });
    }

    @Override
    public boolean canPipeConnectFrom(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z, side){
            private final IBlockAccess w$7;
            private final int x$24;
            private final int y$7;
            private final int z$7;
            private final ForgeDirection side$5;

            public final boolean apply(IPressureExtension x$12) {
                return x$12.canPipeConnectFrom(this.w$7, this.x$24, this.y$7, this.z$7, this.side$5);
            }
            {
                this.w$7 = w$7;
                this.x$24 = x$24;
                this.y$7 = y$7;
                this.z$7 = z$7;
                this.side$5 = side$5;
            }
        });
    }

    @Override
    public boolean isConnectableBlock(IBlockAccess w, int x, int y, int z) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z){
            private final IBlockAccess w$1;
            private final int x$18;
            private final int y$1;
            private final int z$1;

            public final boolean apply(IPressureExtension x$13) {
                return x$13.isConnectableBlock(this.w$1, this.x$18, this.y$1, this.z$1);
            }
            {
                this.w$1 = w$1;
                this.x$18 = x$18;
                this.y$1 = y$1;
                this.z$1 = z$1;
            }
        });
    }

    public boolean canPipeConnectTo(BlockRef ref, ForgeDirection side) {
        return ref.world().exists((Function1)new Serializable(ref, side){
            public final BlockRef ref$3;
            public final ForgeDirection side$1;

            public final boolean apply(WorldServer w) {
                return Helper$.MODULE$.extensions().exists((Function1)new Serializable(this, w){
                    private final /* synthetic */ anonfun.canPipeConnectTo.4 $outer;
                    private final WorldServer w$8;

                    public final boolean apply(IPressureExtension x$14) {
                        return x$14.canPipeConnectTo((IBlockAccess)this.w$8, this.$outer.ref$3.x(), this.$outer.ref$3.y(), this.$outer.ref$3.z(), this.$outer.side$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$8 = w$8;
                    }
                });
            }
            {
                this.ref$3 = ref$3;
                this.side$1 = side$1;
            }
        });
    }

    public boolean canPipeConnectFrom(BlockRef ref, ForgeDirection side) {
        return ref.world().exists((Function1)new Serializable(ref, side){
            public final BlockRef ref$4;
            public final ForgeDirection side$4;

            public final boolean apply(WorldServer w) {
                return Helper$.MODULE$.extensions().exists((Function1)new Serializable(this, w){
                    private final /* synthetic */ anonfun.canPipeConnectFrom.2 $outer;
                    private final WorldServer w$9;

                    public final boolean apply(IPressureExtension x$15) {
                        return x$15.canPipeConnectFrom((IBlockAccess)this.w$9, this.$outer.ref$4.x(), this.$outer.ref$4.y(), this.$outer.ref$4.z(), this.$outer.side$4);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$9 = w$9;
                    }
                });
            }
            {
                this.ref$4 = ref$4;
                this.side$4 = side$4;
            }
        });
    }

    public boolean isConnectableBlock(BlockRef ref) {
        return ref.world().exists((Function1)new Serializable(ref){
            public final BlockRef ref$1;

            public final boolean apply(WorldServer w) {
                return Helper$.MODULE$.extensions().exists((Function1)new Serializable(this, w){
                    private final /* synthetic */ anonfun.isConnectableBlock.3 $outer;
                    private final WorldServer w$10;

                    public final boolean apply(IPressureExtension x$16) {
                        return x$16.isConnectableBlock((IBlockAccess)this.w$10, this.$outer.ref$1.x(), this.$outer.ref$1.y(), this.$outer.ref$1.z());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$10 = w$10;
                    }
                });
            }
            {
                this.ref$1 = ref$1;
            }
        });
    }

    @Override
    public boolean tryPlacePipe(World w, int x, int y, int z, EntityPlayerMP p) {
        return this.extensions().exists((Function1)new Serializable(w, x, y, z, p){
            private final World w$3;
            private final int x$20;
            private final int y$3;
            private final int z$3;
            private final EntityPlayerMP p$1;

            public final boolean apply(IPressureExtension x$17) {
                return x$17.tryPlacePipe(this.w$3, this.x$20, this.y$3, this.z$3, this.p$1);
            }
            {
                this.w$3 = w$3;
                this.x$20 = x$20;
                this.y$3 = y$3;
                this.z$3 = z$3;
                this.p$1 = p$1;
            }
        });
    }

    @Override
    public void registerExtension(IPressureExtension ext) {
        this.extensions_$eq((List<IPressureExtension>)((List)this.extensions().$colon$plus((Object)ext, List$.MODULE$.canBuildFrom())));
    }

    private Helper$() {
        MODULE$ = this;
        this.extensions = List$.MODULE$.empty();
        this.registerExtension(InternalPressureExtension$.MODULE$);
        this.recursionGuard = new anon.1();
    }
}

